/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import org.apache.jmeter.samplers.SampleResult;

public class Calculator {
    private double sum = 0.0;
    private double sumOfSquares = 0.0;
    private double mean = 0.0;
    private double deviation = 0.0;
    private int count = 0;
    private long bytes = 0L;
    private long maximum = Long.MIN_VALUE;
    private long minimum = Long.MAX_VALUE;
    private int errors = 0;
    private final String label;
    private long startTime = 0L;
    private long elapsedTime = 0L;

    public Calculator() {
        this("");
    }

    public Calculator(String label) {
        this.label = label;
    }

    public void clear() {
        this.maximum = Long.MIN_VALUE;
        this.minimum = Long.MAX_VALUE;
        this.sum = 0.0;
        this.sumOfSquares = 0.0;
        this.mean = 0.0;
        this.deviation = 0.0;
        this.count = 0;
    }

    @Deprecated
    public void addValue(long newValue) {
        this.addValue(newValue, 1);
    }

    private void addValue(long newValue, int sampleCount) {
        this.count += sampleCount;
        double currentVal = newValue;
        this.sum += currentVal;
        if (sampleCount > 1) {
            this.minimum = Math.min(newValue / (long)sampleCount, this.minimum);
            this.maximum = Math.max(newValue / (long)sampleCount, this.maximum);
            this.sumOfSquares += currentVal * currentVal / (double)sampleCount;
        } else {
            this.minimum = Math.min(newValue, this.minimum);
            this.maximum = Math.max(newValue, this.maximum);
            this.sumOfSquares += currentVal * currentVal;
        }
        this.mean = this.sum / (double)this.count;
        this.deviation = Math.sqrt(this.sumOfSquares / (double)this.count - this.mean * this.mean);
    }

    public void addBytes(long newValue) {
        this.bytes += newValue;
    }

    public void addSample(SampleResult res) {
        this.addBytes(res.getBytes());
        this.addValue(res.getTime(), res.getSampleCount());
        this.errors += res.getErrorCount();
        this.startTime = this.startTime == 0L ? res.getStartTime() : Math.min(this.startTime, res.getStartTime());
        this.elapsedTime = Math.max(this.elapsedTime, res.getEndTime() - this.startTime);
    }

    public long getTotalBytes() {
        return this.bytes;
    }

    public double getMean() {
        return this.mean;
    }

    public Number getMeanAsNumber() {
        return (long)this.mean;
    }

    public double getStandardDeviation() {
        return this.deviation;
    }

    public long getMin() {
        return this.minimum;
    }

    public long getMax() {
        return this.maximum;
    }

    public int getCount() {
        return this.count;
    }

    public String getLabel() {
        return this.label;
    }

    public double getErrorPercentage() {
        double rval = 0.0;
        if (this.count == 0) {
            return rval;
        }
        rval = (double)this.errors / (double)this.count;
        return rval;
    }

    public double getRate() {
        if (this.elapsedTime == 0L) {
            return 0.0;
        }
        return (double)this.count / (double)this.elapsedTime * 1000.0;
    }

    public double getAvgPageBytes() {
        if (this.count > 0 && this.bytes > 0L) {
            return (double)this.bytes / (double)this.count;
        }
        return 0.0;
    }

    public double getBytesPerSecond() {
        if (this.elapsedTime > 0L) {
            return (double)this.bytes / ((double)this.elapsedTime / 1000.0);
        }
        return 0.0;
    }

    public double getKBPerSecond() {
        return this.getBytesPerSecond() / 1024.0;
    }
}

