/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.Parameters;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StringBasedMongoQuery
extends AbstractMongoQuery {
    private static final String COUND_AND_DELETE = "Manually defined query for %s cannot be both a count and delete query at the same time!";
    private static final Logger LOG = LoggerFactory.getLogger(StringBasedMongoQuery.class);
    private static final ParameterBindingParser BINDING_PARSER = ParameterBindingParser.INSTANCE;
    private final String query;
    private final String fieldSpec;
    private final boolean isCountQuery;
    private final boolean isDeleteQuery;
    private final List<ParameterBinding> queryParameterBindings;
    private final List<ParameterBinding> fieldSpecParameterBindings;
    private final SpelExpressionParser expressionParser;
    private final EvaluationContextProvider evaluationContextProvider;

    public StringBasedMongoQuery(MongoQueryMethod method, MongoOperations mongoOperations, SpelExpressionParser expressionParser, EvaluationContextProvider evaluationContextProvider) {
        this(method.getAnnotatedQuery(), method, mongoOperations, expressionParser, evaluationContextProvider);
    }

    public StringBasedMongoQuery(String query, MongoQueryMethod method, MongoOperations mongoOperations, SpelExpressionParser expressionParser, EvaluationContextProvider evaluationContextProvider) {
        super(method, mongoOperations);
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)expressionParser, (String)"SpelExpressionParser must not be null!");
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
        this.queryParameterBindings = new ArrayList<ParameterBinding>();
        this.query = BINDING_PARSER.parseAndCollectParameterBindingsFromQueryIntoBindings(query, this.queryParameterBindings);
        this.fieldSpecParameterBindings = new ArrayList<ParameterBinding>();
        this.fieldSpec = BINDING_PARSER.parseAndCollectParameterBindingsFromQueryIntoBindings(method.getFieldSpecification(), this.fieldSpecParameterBindings);
        this.isCountQuery = method.hasAnnotatedQuery() ? method.getQueryAnnotation().count() : false;
        boolean bl = this.isDeleteQuery = method.hasAnnotatedQuery() ? method.getQueryAnnotation().delete() : false;
        if (this.isCountQuery && this.isDeleteQuery) {
            throw new IllegalArgumentException(String.format(COUND_AND_DELETE, new Object[]{method}));
        }
    }

    @Override
    protected Query createQuery(ConvertingParameterAccessor accessor) {
        String queryString = this.replacePlaceholders(this.query, accessor, this.queryParameterBindings);
        BasicQuery query = null;
        if (this.fieldSpec != null) {
            String fieldString = this.replacePlaceholders(this.fieldSpec, accessor, this.fieldSpecParameterBindings);
            query = new BasicQuery(queryString, fieldString);
        } else {
            query = new BasicQuery(queryString);
        }
        query.with(accessor.getSort());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Created query %s", ((Query)query).getQueryObject()));
        }
        return query;
    }

    @Override
    protected boolean isCountQuery() {
        return this.isCountQuery;
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.isDeleteQuery;
    }

    private String replacePlaceholders(String input, ConvertingParameterAccessor accessor, List<ParameterBinding> bindings) {
        if (bindings.isEmpty()) {
            return input;
        }
        boolean isCompletlyParameterizedQuery = input.matches("^\\?\\d+$");
        StringBuilder result = new StringBuilder(input);
        for (ParameterBinding binding : bindings) {
            String parameter = binding.getParameter();
            int idx = result.indexOf(parameter);
            if (idx == -1) continue;
            String valueForBinding = this.getParameterValueForBinding(accessor, binding);
            boolean shouldPotentiallyRemoveQuotes = valueForBinding.startsWith("{") && !isCompletlyParameterizedQuery;
            int start = idx;
            int end = idx + parameter.length();
            if (shouldPotentiallyRemoveQuotes) {
                char beforeStart = result.charAt(start - 1);
                char afterEnd = result.charAt(end);
                if (!(beforeStart != '\'' && beforeStart != '\"' || afterEnd != '\'' && afterEnd != '\"')) {
                    --start;
                    ++end;
                }
            }
            result.replace(start, end, valueForBinding);
        }
        return result.toString();
    }

    private String getParameterValueForBinding(ConvertingParameterAccessor accessor, ParameterBinding binding) {
        Object value;
        Object object = value = binding.isExpression() ? this.evaluateExpression(binding.getExpression(), accessor.getValues()) : accessor.getBindableValue(binding.getParameterIndex());
        if (value instanceof String && binding.isQuoted()) {
            return (String)value;
        }
        return JSON.serialize((Object)value);
    }

    private Object evaluateExpression(String expressionString, Object[] parameterValues) {
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext((Parameters)this.getQueryMethod().getParameters(), parameterValues);
        Expression expression = this.expressionParser.parseExpression(expressionString);
        return expression.getValue(evaluationContext, Object.class);
    }

    private static class ParameterBinding {
        private final int parameterIndex;
        private final boolean quoted;
        private final String expression;

        public ParameterBinding(int parameterIndex, boolean quoted) {
            this(parameterIndex, quoted, null);
        }

        public ParameterBinding(int parameterIndex, boolean quoted, String expression) {
            this.parameterIndex = parameterIndex;
            this.quoted = quoted;
            this.expression = expression;
        }

        public boolean isQuoted() {
            return this.quoted;
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        public String getParameter() {
            return "?" + (this.isExpression() ? "expr" : "") + this.parameterIndex;
        }

        public String getExpression() {
            return this.expression;
        }

        public boolean isExpression() {
            return this.expression != null;
        }
    }

    private static enum ParameterBindingParser {
        INSTANCE;

        private static final String EXPRESSION_PARAM_QUOTE = "'";
        private static final String EXPRESSION_PARAM_PREFIX = "?expr";
        private static final String INDEX_BASED_EXPRESSION_PARAM_START = "?#{";
        private static final String NAME_BASED_EXPRESSION_PARAM_START = ":#{";
        private static final char CURRLY_BRACE_OPEN = '{';
        private static final char CURRLY_BRACE_CLOSE = '}';
        private static final String PARAMETER_PREFIX = "_param_";
        private static final String PARSEABLE_PARAMETER = "\"_param_$1\"";
        private static final Pattern PARAMETER_BINDING_PATTERN;
        private static final Pattern PARSEABLE_BINDING_PATTERN;
        private static final int PARAMETER_INDEX_GROUP = 1;

        public String parseAndCollectParameterBindingsFromQueryIntoBindings(String input, List<ParameterBinding> bindings) {
            if (!StringUtils.hasText((String)input)) {
                return input;
            }
            Assert.notNull(bindings, (String)"Parameter bindings must not be null!");
            String transformedInput = ParameterBindingParser.transformQueryAndCollectExpressionParametersIntoBindings(input, bindings);
            String parseableInput = ParameterBindingParser.makeParameterReferencesParseable(transformedInput);
            ParameterBindingParser.collectParameterReferencesIntoBindings(bindings, JSON.parse((String)parseableInput));
            return transformedInput;
        }

        private static String transformQueryAndCollectExpressionParametersIntoBindings(String input, List<ParameterBinding> bindings) {
            int indexOfExpressionParameter;
            StringBuilder result = new StringBuilder();
            int startIndex = 0;
            int currentPos = 0;
            int exprIndex = 0;
            while (currentPos < input.length() && (indexOfExpressionParameter = ParameterBindingParser.getIndexOfExpressionParameter(input, currentPos)) >= 0) {
                int exprStart;
                currentPos = exprStart = indexOfExpressionParameter + 3;
                int curlyBraceOpenCnt = 1;
                block5: while (curlyBraceOpenCnt > 0) {
                    switch (input.charAt(currentPos++)) {
                        case '{': {
                            ++curlyBraceOpenCnt;
                            continue block5;
                        }
                        case '}': {
                            --curlyBraceOpenCnt;
                            continue block5;
                        }
                    }
                }
                result.append(input.subSequence(startIndex, indexOfExpressionParameter));
                result.append(EXPRESSION_PARAM_QUOTE).append(EXPRESSION_PARAM_PREFIX);
                result.append(exprIndex);
                result.append(EXPRESSION_PARAM_QUOTE);
                bindings.add(new ParameterBinding(exprIndex, true, input.substring(exprStart, currentPos - 1)));
                startIndex = currentPos;
                ++exprIndex;
            }
            return result.append(input.subSequence(currentPos, input.length())).toString();
        }

        private static String makeParameterReferencesParseable(String input) {
            Matcher matcher = PARAMETER_BINDING_PATTERN.matcher(input);
            return matcher.replaceAll(PARSEABLE_PARAMETER);
        }

        private static void collectParameterReferencesIntoBindings(List<ParameterBinding> bindings, Object value) {
            block3: {
                block5: {
                    block4: {
                        block2: {
                            if (!(value instanceof String)) break block2;
                            String string = ((String)value).trim();
                            ParameterBindingParser.potentiallyAddBinding(string, bindings);
                            break block3;
                        }
                        if (!(value instanceof Pattern)) break block4;
                        String string = ((Pattern)value).toString().trim();
                        Matcher valueMatcher = PARSEABLE_BINDING_PATTERN.matcher(string);
                        while (valueMatcher.find()) {
                            int paramIndex = Integer.parseInt(valueMatcher.group(1));
                            boolean quoted = !string.equals(PARAMETER_PREFIX + paramIndex);
                            bindings.add(new ParameterBinding(paramIndex, quoted));
                        }
                        break block3;
                    }
                    if (!(value instanceof DBRef)) break block5;
                    DBRef dbref = (DBRef)value;
                    ParameterBindingParser.potentiallyAddBinding(dbref.getCollectionName(), bindings);
                    ParameterBindingParser.potentiallyAddBinding(dbref.getId().toString(), bindings);
                    break block3;
                }
                if (!(value instanceof DBObject)) break block3;
                DBObject dbo = (DBObject)value;
                for (String field : dbo.keySet()) {
                    ParameterBindingParser.collectParameterReferencesIntoBindings(bindings, field);
                    ParameterBindingParser.collectParameterReferencesIntoBindings(bindings, dbo.get(field));
                }
            }
        }

        private static void potentiallyAddBinding(String source, List<ParameterBinding> bindings) {
            Matcher valueMatcher = PARSEABLE_BINDING_PATTERN.matcher(source);
            while (valueMatcher.find()) {
                int paramIndex = Integer.parseInt(valueMatcher.group(1));
                boolean quoted = source.startsWith(EXPRESSION_PARAM_QUOTE) && source.endsWith(EXPRESSION_PARAM_QUOTE) || source.startsWith("\"") && source.endsWith("\"");
                bindings.add(new ParameterBinding(paramIndex, quoted));
            }
        }

        private static int getIndexOfExpressionParameter(String input, int position) {
            int indexOfExpressionParameter = input.indexOf(INDEX_BASED_EXPRESSION_PARAM_START, position);
            return indexOfExpressionParameter < 0 ? input.indexOf(NAME_BASED_EXPRESSION_PARAM_START, position) : indexOfExpressionParameter;
        }

        static {
            PARAMETER_BINDING_PATTERN = Pattern.compile("\\?(\\d+)");
            PARSEABLE_BINDING_PATTERN = Pattern.compile("\"?_param_(\\d+)\"?");
        }
    }
}

