/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;

public class StaleConnectionTrackingHandler
extends SimpleChannelHandler {
    private final Map<Channel, Long> stamps = new HashMap<Channel, Long>();
    private final long timeout;
    private final Executor executor;

    public StaleConnectionTrackingHandler(long timeout, Executor executor) {
        this.timeout = timeout;
        this.executor = executor;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.stamp(e.getChannel());
        super.channelOpen(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.stamp(e.getChannel());
        super.messageReceived(ctx, e);
    }

    private void stamp(final Channel channel) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                StaleConnectionTrackingHandler.this.stamps.put(channel, System.currentTimeMillis());
            }
        });
    }

    public void closeStaleConnections() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                Iterator entries = StaleConnectionTrackingHandler.this.stamps.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    if (!StaleConnectionTrackingHandler.this.isStale((Long)entry.getValue())) continue;
                    ((Channel)entry.getKey()).close();
                    entries.remove();
                }
            }
        });
    }

    public void stopTracking(final Channel channel) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                StaleConnectionTrackingHandler.this.stamps.remove(channel);
            }
        });
    }

    private boolean isStale(Long timeStamp) {
        return System.currentTimeMillis() - timeStamp > this.timeout;
    }
}

