/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.modifier.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.processor.gui.AbstractPreProcessorGui;
import org.apache.jmeter.protocol.http.modifier.ParamMask;
import org.apache.jmeter.protocol.http.modifier.ParamModifier;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class ParamModifierGui
extends AbstractPreProcessorGui
implements FocusListener {
    private static final long serialVersionUID = 240L;
    private static final String NAME = "name";
    private static final String PREFIX = "prefix";
    private static final String LOWERBOUND = "lowerBound";
    private static final String UPPERBOUND = "upperBound";
    private static final String INCREMENT = "increment";
    private static final String SUFFIX = "suffix";
    private static final String ZERO = "0";
    private JTextField _fieldName;
    private JTextField _prefix;
    private JTextField _lowerBound;
    private JTextField _upperBound;
    private JTextField _increment;
    private JTextField _suffix;

    public ParamModifierGui() {
        this.init();
    }

    public String getLabelResource() {
        return "html_parameter_mask";
    }

    public void configure(TestElement el) {
        super.configure(el);
        ParamModifier model = (ParamModifier)el;
        this.updateGui(model);
    }

    public TestElement createTestElement() {
        ParamModifier modifier = new ParamModifier();
        this.modifyTestElement((TestElement)modifier);
        return modifier;
    }

    public void modifyTestElement(TestElement m) {
        this.configureTestElement(m);
        if (m instanceof ParamModifier) {
            ParamModifier modifier = (ParamModifier)m;
            ParamMask mask = modifier.getMask();
            mask.setFieldName(this._fieldName.getText());
            mask.setPrefix(this._prefix.getText());
            mask.setLowerBound(Long.parseLong(this._lowerBound.getText()));
            mask.setIncrement(Long.parseLong(this._increment.getText()));
            mask.setUpperBound(Long.parseLong(this._upperBound.getText()));
            mask.setSuffix(this._suffix.getText());
        }
    }

    public void clearGui() {
        super.clearGui();
        this._fieldName.setText("");
        this._prefix.setText("");
        this._lowerBound.setText(ZERO);
        this._upperBound.setText("10");
        this._increment.setText("1");
        this._suffix.setText("");
    }

    @Override
    public void focusGained(FocusEvent evt) {
    }

    @Override
    public void focusLost(FocusEvent evt) {
        String name = ((Component)evt.getSource()).getName();
        if (evt.isTemporary()) {
            return;
        }
        if (name.equals(LOWERBOUND)) {
            this.checkTextField(evt, ZERO);
        } else if (name.equals(UPPERBOUND)) {
            this.checkTextField(evt, ZERO);
        } else if (name.equals(INCREMENT)) {
            this.checkTextField(evt, ZERO);
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.add(this.getParameterMaskPanel(), "Center");
    }

    private void updateGui(ParamModifier model) {
        this._fieldName.setText(model.getMask().getFieldName());
        this._prefix.setText(model.getMask().getPrefix());
        this._lowerBound.setText(Long.toString(model.getMask().getLowerBound()));
        this._upperBound.setText(Long.toString(model.getMask().getUpperBound()));
        this._increment.setText(Long.toString(model.getMask().getIncrement()));
        this._suffix.setText(model.getMask().getSuffix());
    }

    private JPanel createLabeledField(String labelResName, JTextField field) {
        JLabel label = new JLabel(JMeterUtils.getResString((String)labelResName));
        label.setLabelFor(field);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)field, "Center");
        return panel;
    }

    private JPanel getParameterMaskPanel() {
        HorizontalPanel panel = new HorizontalPanel(10, 0.0f);
        panel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"html_parameter_mask")));
        this._fieldName = new JTextField(10);
        this._fieldName.setName(NAME);
        panel.add((Component)this.createLabeledField(NAME, this._fieldName));
        this._prefix = new JTextField(5);
        this._prefix.setName(PREFIX);
        panel.add((Component)this.createLabeledField("id_prefix", this._prefix));
        this._lowerBound = new JTextField(ZERO, 5);
        this._lowerBound.addFocusListener(this);
        this._lowerBound.setName(LOWERBOUND);
        panel.add((Component)this.createLabeledField("lower_bound", this._lowerBound));
        this._upperBound = new JTextField("10", 5);
        this._upperBound.addFocusListener(this);
        this._upperBound.setName(UPPERBOUND);
        panel.add((Component)this.createLabeledField("upper_bound", this._upperBound));
        this._increment = new JTextField("1", 3);
        this._increment.addFocusListener(this);
        this._increment.setName(INCREMENT);
        panel.add((Component)this.createLabeledField(INCREMENT, this._increment));
        this._suffix = new JTextField(5);
        this._suffix.setName(SUFFIX);
        panel.add((Component)this.createLabeledField("id_suffix", this._suffix));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)panel, "North");
        return mainPanel;
    }

    private long checkTextField(FocusEvent evt, String defaultValue) {
        JTextField temp = (JTextField)evt.getSource();
        long longVal = 0L;
        try {
            longVal = Long.parseLong(temp.getText());
        }
        catch (NumberFormatException err) {
            JOptionPane.showMessageDialog((Component)((Object)this), "This field must have a long value!", "Value Required", 0);
            temp.setText(defaultValue);
            temp.requestFocus();
        }
        return longVal;
    }
}

