/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.pool;

import org.apache.avalon.excalibur.pool.DefaultObjectFactory;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.PoolController;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.excalibur.pool.Resizable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.SingleThreaded;

public class SingleThreadedPool
extends AbstractLogEnabled
implements Pool,
Initializable,
SingleThreaded,
Resizable,
Disposable {
    protected boolean m_initialized;
    protected int m_count = 0;
    protected Poolable[] m_pool;
    protected ObjectFactory m_factory;
    protected PoolController m_controller;
    protected int m_maximum;
    protected int m_initial;

    public SingleThreadedPool(Class clazz, int initial, int maximum) throws Exception {
        this(new DefaultObjectFactory(clazz), initial, maximum);
    }

    public SingleThreadedPool(ObjectFactory factory, int initial, int maximum) throws Exception {
        this(factory, null, initial, maximum);
    }

    public SingleThreadedPool(ObjectFactory factory, PoolController controller, int initial, int maximum) throws Exception {
        this.m_factory = factory;
        this.m_controller = controller;
        this.m_maximum = maximum;
        this.m_initial = initial;
    }

    public void initialize() throws Exception {
        this.m_initialized = true;
        this.grow(this.m_maximum);
        this.fill(this.m_initial);
    }

    public Poolable get() throws Exception {
        int increase;
        if (!this.m_initialized) {
            this.initialize();
        }
        if (null == this.m_pool && null != this.m_controller && (increase = this.m_controller.grow()) > 0) {
            this.grow(increase);
        }
        if (0 > this.m_count) {
            this.m_count = -1;
            return (Poolable)this.m_factory.newInstance();
        }
        if (0 == this.m_count) {
            --this.m_count;
            return this.m_pool[0];
        }
        Poolable poolable = this.m_pool[this.m_count];
        this.m_pool[this.m_count] = null;
        --this.m_count;
        return poolable;
    }

    public void put(Poolable poolable) {
        block6: {
            int decrease;
            if (poolable instanceof Recyclable) {
                ((Recyclable)poolable).recycle();
            }
            if (this.m_pool.length == this.m_count + 1 && null != this.m_controller && (decrease = this.m_controller.shrink()) > 0) {
                this.shrink(decrease);
            }
            if (this.m_pool.length > this.m_count + 1) {
                ++this.m_count;
                this.m_pool[this.m_count] = poolable;
            } else {
                try {
                    this.m_factory.decommission(poolable);
                }
                catch (Exception e) {
                    if (this.getLogger() == null || !this.getLogger().isDebugEnabled()) break block6;
                    this.getLogger().debug("Error decommissioning object", (Throwable)e);
                }
            }
        }
    }

    public final int getCapacity() {
        return this.m_pool.length;
    }

    public final int getSize() {
        return this.m_count;
    }

    public final int size() {
        return this.getSize();
    }

    public final void fill(int fillSize) throws Exception {
        int size = Math.min(this.m_pool.length, fillSize);
        int i = this.m_count;
        while (i < size) {
            this.m_pool[i] = (Poolable)this.m_factory.newInstance();
            ++i;
        }
        this.m_count = size - 1;
    }

    public final void grow(int increase) {
        if (null == this.m_pool) {
            this.m_pool = new Poolable[increase];
            return;
        }
        Poolable[] poolables = new Poolable[increase + this.m_pool.length];
        System.arraycopy(this.m_pool, 0, poolables, 0, this.m_pool.length);
        this.m_pool = poolables;
    }

    public final void shrink(int decrease) {
        Poolable[] poolables = new Poolable[this.m_pool.length - decrease];
        System.arraycopy(this.m_pool, 0, poolables, 0, poolables.length);
        this.m_pool = poolables;
    }

    public void dispose() {
        while (this.m_count > 0) {
            block3: {
                int i = this.m_count - 1;
                try {
                    this.m_factory.decommission(this.m_pool[i]);
                }
                catch (Exception e) {
                    if (this.getLogger() == null || !this.getLogger().isDebugEnabled()) break block3;
                    this.getLogger().debug("Error decommissioning object", (Throwable)e);
                }
            }
            this.m_pool[i] = null;
            --this.m_count;
        }
    }
}

