/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.IOException;
import java.io.Reader;

public class BoundedReader
extends Reader {
    private final Reader target;
    int pos = 0;
    int readAheadLimit;

    public BoundedReader(Reader target, int readAheadLimit) throws IOException {
        this.target = target;
        target.mark(readAheadLimit);
        this.readAheadLimit = readAheadLimit;
    }

    public void close() throws IOException {
        this.target.close();
    }

    public void reset() throws IOException {
        this.pos = 0;
        this.target.reset();
    }

    public void mark(int readAheadLimit) throws IOException {
        this.readAheadLimit = readAheadLimit;
        this.target.mark(readAheadLimit);
    }

    public int read() throws IOException {
        if (this.pos >= this.readAheadLimit) {
            return -1;
        }
        ++this.pos;
        return this.target.read();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                return i;
            }
            cbuf[off + i] = (char)c;
        }
        return len;
    }
}

