/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.codegen.function;

import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kurento.modulecreator.definition.ComplexType;
import org.kurento.modulecreator.definition.Event;
import org.kurento.modulecreator.definition.Import;
import org.kurento.modulecreator.definition.ModuleDefinition;
import org.kurento.modulecreator.definition.RemoteClass;

public class SphinxLinks
implements TemplateMethodModelEx {
    private static Pattern glossary_term_1 = Pattern.compile(":term:`([^`<]*?)`");
    private static Pattern glossary_term_2 = Pattern.compile(":term:`([^`<]*?)<([^`]*?)>`");
    private static String glossary_href = "<a href=\"http://www.kurento.org/docs/current/glossary.html#term-%s\">%s</a>";
    private List<String[]> toReplace = new ArrayList(Arrays.asList({":wikipedia:`(.*?),(.*?)`", "<a href=\"http://$1.wikipedia.org/wiki/$2\">$2</a>"}, {":wikipedia:`(.*?)<(.*?),(.*?)>`", "<a href=\"http://$2.wikipedia.org/wiki/$3\">$1</a>"}, {":java:ref:`([^`]*?)<(.*?)>`", "{@link $2 $1}"}, {":java:ref:`(.*?)`", "{@link $1}"}, {":rom:enum:`([^`]*?)`", "{@link $1}"}, {":rom:evt:`([^`]*?)<([^`]*?)>`", "{@link $2 $1Event}"}, {":rom:evt:`([^`]*?)`", "{@link $1Event}"}, {":author:", "@author"}, {":since:", "@since"}, {"``([^`]*?)``", "<code>$1</code>"}, {"\\.\\.\\s+todo::(.*?)", "<hr/><b>TODO</b>$1"}, {"\\.\\.\\s+note::(.*?)", "<hr/><b>Note</b>$1"}));
    String _non_id_chars = "[^a-z0-9]+";
    String _non_id_at_ends = "^[-0-9]+|-+$";
    List<String[]> _non_id_translate = Arrays.asList({"\u00f8", "o"}, {"\u0111", "d"}, {"\u0127", "h"}, {"\u0131", "i"}, {"\u0142", "l"}, {"\u0167", "t"}, {"\u0180", "b"}, {"\u0183", "b"}, {"\u0188", "c"}, {"\u018c", "d"}, {"\u0192", "f"}, {"\u0199", "k"}, {"\u019a", "l"}, {"\u019e", "n"}, {"\u01a5", "p"}, {"\u01ab", "t"}, {"\u01ad", "t"}, {"\u01b4", "y"}, {"\u01b6", "z"}, {"\u01e5", "g"}, {"\u0225", "z"}, {"\u0234", "l"}, {"\u0235", "n"}, {"\u0236", "t"}, {"\u0237", "j"}, {"\u023c", "c"}, {"\u023f", "s"}, {"\u0240", "z"}, {"\u0247", "e"}, {"\u0249", "j"}, {"\u024b", "q"}, {"\u024d", "r"}, {"\u024f", "y"});
    List<String[]> _non_id_translate_digraphs = Arrays.asList({"\u00df", "sz"}, {"\u00e6", "ae"}, {"\u0153", "oe"}, {"\u0238", "db"}, {"\u0239", "qp"});

    public SphinxLinks(ModuleDefinition module) {
        this.addModule(module);
        for (Import i : module.getImports()) {
            this.addModule(i.getModule());
        }
    }

    private void addModule(ModuleDefinition module) {
        this.addRemoteClasses(module);
        this.addComplexTypes(module);
        this.addEvents(module);
    }

    private void addRemoteClasses(ModuleDefinition module) {
        for (RemoteClass remoteClass : module.getRemoteClasses()) {
            String className = remoteClass.getName();
            String namePath = "module:" + module.getName();
            namePath = namePath + (remoteClass.isAbstract() ? "/abstracts" : "");
            namePath = namePath + "." + className;
            this.toReplace.addAll(Arrays.asList({":rom:cls:`" + className + "`", "{@link " + namePath + " " + className + "}"}, {":rom:cls:`([^`]*?)<" + className + ">`", "{@link " + namePath + " $1}"}));
        }
    }

    private void addComplexTypes(ModuleDefinition module) {
        for (ComplexType complexType : module.getComplexTypes()) {
            String typeName = complexType.getName();
            String namePath = "module:" + module.getName() + "/complexTypes." + typeName;
            this.toReplace.addAll(Arrays.asList({":rom:ref:`" + typeName + "`", "{@link " + namePath + " " + typeName + "}"}, {":rom:ref:`([^`]*?)<" + typeName + ">`", "{@link " + namePath + " $1}"}));
        }
    }

    private void addEvents(ModuleDefinition module) {
        for (Event event : module.getEvents()) {
            String eventName = event.getName();
            String namePath = "module:" + module.getName() + "#event:" + eventName;
            this.toReplace.addAll(Arrays.asList({":rom:evt:`" + eventName + "`", "{@link " + namePath + " " + eventName + "}"}, {":rom:evt:`([^`]*?)<" + eventName + ">`", "{@link " + namePath + " $1}"}));
        }
    }

    public Object exec(List arguments) throws TemplateModelException {
        String typeName = arguments.get(0).toString();
        String res = this.translate(typeName, this.toReplace);
        String classNamePath = arguments.size() > 1 ? "module:" + arguments.get(1).toString() : "";
        String instanceProperty = "{@link " + classNamePath + "#$1}";
        String instancePropertyAlt = "{@link " + classNamePath + "#$2 $1}";
        res = this.translate(res, Arrays.asList({":rom:meth:`([^`]*?)<([^`]*?)>`", instancePropertyAlt}, {":rom:meth:`([^`]*?)`", instanceProperty}, {":rom:attr:`([^`]*?)<([^`]*?)>`", instancePropertyAlt}, {":rom:attr:`([^`]*?)`", instanceProperty}));
        Matcher m2 = glossary_term_2.matcher(res);
        while (m2.find()) {
            res = res.substring(0, m2.start() - 1) + String.format(glossary_href, this.make_id(m2.group(2)), m2.group(1)) + res.substring(m2.end() + 1);
        }
        m2 = glossary_term_1.matcher(res);
        while (m2.find()) {
            res = res.substring(0, m2.start()) + String.format(glossary_href, this.make_id(m2.group(1)), m2.group(1)) + res.substring(m2.end());
        }
        return res;
    }

    public String translate(String text, List<String[]> patterns) {
        String res = text;
        for (String[] each : patterns) {
            res = res.replaceAll("(?ms)" + each[0], each[1]);
        }
        return res;
    }

    public String make_id(String txt) {
        String id = txt.toLowerCase();
        id = this.translate(id, this._non_id_translate_digraphs);
        id = this.translate(id, this._non_id_translate);
        id = id.replaceAll("\\s+", " ").replaceAll(this._non_id_chars, "-");
        id = id.replaceAll(this._non_id_at_ends, "");
        return id;
    }
}

