/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.definition;

import java.util.HashMap;
import java.util.Map;
import org.kurento.modulecreator.ModuleManager;
import org.kurento.modulecreator.VersionManager;
import org.kurento.modulecreator.definition.ModuleDefinition;

public class Code {
    private Map<String, Map<String, String>> kmd;
    private Map<String, Map<String, String>> api;
    private Map<String, String> implementation;

    public void completeInfo(ModuleDefinition module, ModuleManager moduleManager) {
        if (this.api == null) {
            this.api = new HashMap<String, Map<String, String>>();
        }
        this.putDefault(this.api, "java", "packageName", "org.kurento.module." + module.getName());
        this.putDefault(this.api, "java", "mavenGroupId", "org.kurento.module");
        this.putDefault(this.api, "java", "mavenArtifactId", module.getName());
        this.putDefault(this.api, "java", "mavenVersion", VersionManager.convertToMaven(module.getVersion()));
        this.putDefault(this.api, "js", "nodeName", "kurento-module-" + module.getName());
        String npmGit = module.getCode().getApi().get("js").get("npmGit");
        this.putDefault(this.api, "js", "npmVersion", VersionManager.convertToNpm(npmGit, module.getVersion()));
        this.putDefault(this.api, "js", "npmDescription", "");
        if (this.implementation == null) {
            this.implementation = new HashMap<String, String>();
        }
        this.putDefault(this.implementation, "cppNamespace", "kurento::module::" + module.getName());
        this.putDefault(this.implementation, "lib", "libkms" + module.getName().toLowerCase());
        if (this.kmd != null) {
            this.putDefault(this.kmd, "java", "mavenGroupId", "org.kurento.module");
            this.putDefault(this.kmd, "java", "mavenArtifactId", module.getName() + ".kmd");
            this.putDefault(this.kmd, "java", "mavenVersion", VersionManager.convertToMaven(module.getVersion()));
        }
    }

    private void putDefault(Map<String, String> section, String key, String defaultValue) {
        if (section.get(key) == null) {
            section.put(key, defaultValue);
        }
    }

    private void putDefault(Map<String, Map<String, String>> section, String subsection, String key, String defaultValue) {
        Map<String, String> subsectionMap = section.get(subsection);
        if (subsectionMap == null) {
            subsectionMap = new HashMap<String, String>();
            section.put(subsection, subsectionMap);
            subsectionMap.put(key, defaultValue);
        } else if (subsectionMap.get(key) == null) {
            subsectionMap.put(key, defaultValue);
        }
    }

    public String toString() {
        return "Code [kmd=" + this.kmd + ", api=" + this.api + ", implementation=" + this.implementation + "]";
    }

    public Map<String, Map<String, String>> getKmd() {
        return this.kmd;
    }

    public Map<String, Map<String, String>> getApi() {
        return this.api;
    }

    public Map<String, String> getImplementation() {
        return this.implementation;
    }
}

