/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.definition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kurento.modulecreator.KurentoModuleCreatorException;
import org.kurento.modulecreator.ModuleManager;
import org.kurento.modulecreator.VersionManager;
import org.kurento.modulecreator.definition.Code;
import org.kurento.modulecreator.definition.ComplexType;
import org.kurento.modulecreator.definition.Event;
import org.kurento.modulecreator.definition.Import;
import org.kurento.modulecreator.definition.ModelElement;
import org.kurento.modulecreator.definition.NamedElement;
import org.kurento.modulecreator.definition.PrimitiveType;
import org.kurento.modulecreator.definition.RemoteClass;
import org.kurento.modulecreator.definition.Type;
import org.kurento.modulecreator.definition.TypeRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleDefinition {
    private static final String FILTERS_MODULE = "filters";
    private static final String ELEMENTS_MODULE = "elements";
    private static final String CORE_MODULE = "core";
    private static final Set<String> AUTO_IMPORTED_MODULES = new HashSet<String>(Arrays.asList("core", "elements", "filters"));
    public static final PrimitiveType STRING = new PrimitiveType("String");
    public static final PrimitiveType BOOLEAN = new PrimitiveType("boolean");
    public static final PrimitiveType INT = new PrimitiveType("int");
    public static final PrimitiveType FLOAT = new PrimitiveType("float");
    public static final PrimitiveType DOUBLE = new PrimitiveType("double");
    public static final PrimitiveType INT64 = new PrimitiveType("int64");
    private static Logger log = LoggerFactory.getLogger(ModuleDefinition.class);
    private String name;
    private String version;
    private String kurentoVersion;
    private String kurentoMavenVersion;
    private String kurentoNpmVersion;
    private List<Import> imports;
    private String repository;
    private Code code;
    private List<RemoteClass> remoteClasses;
    private List<ComplexType> complexTypes;
    private List<Event> events;
    private transient Map<String, RemoteClass> remoteClassesMap;
    private transient Map<String, Event> eventsMap;
    private transient Map<String, ComplexType> complexTypesMap;
    private transient Map<String, Type> types;
    private transient ResolutionState resolutionState = ResolutionState.NO_RESOLVED;
    private transient Map<String, Type> allTypes;

    public ModuleDefinition(String name, String version) {
        this();
        this.name = name;
        this.version = version;
    }

    public ModuleDefinition() {
        this.remoteClasses = new ArrayList<RemoteClass>();
        this.complexTypes = new ArrayList<ComplexType>();
        this.events = new ArrayList<Event>();
        this.imports = new ArrayList<Import>();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleDefinition other = (ModuleDefinition)obj;
        if (this.events == null ? other.events != null : !this.events.equals(other.events)) {
            return false;
        }
        if (this.remoteClasses == null ? other.remoteClasses != null : !this.remoteClasses.equals(other.remoteClasses)) {
            return false;
        }
        return !(this.complexTypes == null ? other.complexTypes != null : !this.complexTypes.equals(other.complexTypes));
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public List<RemoteClass> getRemoteClasses() {
        return this.remoteClasses;
    }

    public List<ComplexType> getComplexTypes() {
        return this.complexTypes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.events == null ? 0 : this.events.hashCode());
        result = 31 * result + (this.remoteClasses == null ? 0 : this.remoteClasses.hashCode());
        result = 31 * result + (this.complexTypes == null ? 0 : this.complexTypes.hashCode());
        return result;
    }

    public void addEvent(Event event) {
        this.events.add(event);
    }

    public void addRemoteClass(RemoteClass remoteClass) {
        this.remoteClasses.add(remoteClass);
    }

    public void addType(ComplexType type) {
        this.complexTypes.add(type);
    }

    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public void setRemoteClasses(List<RemoteClass> remoteClasses) {
        this.remoteClasses = remoteClasses;
    }

    public void setComplexTypes(List<ComplexType> types) {
        this.complexTypes = types;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKurentoVersion() {
        return this.kurentoVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public RemoteClass getRemoteClass(String remoteClassName) {
        return this.remoteClassesMap.get(remoteClassName);
    }

    public ComplexType getType(String typeName) {
        return this.complexTypesMap.get(typeName);
    }

    public Event getEvent(String eventName) {
        return this.eventsMap.get(eventName);
    }

    public String getRepository() {
        return this.repository;
    }

    public Code getCode() {
        return this.code;
    }

    public List<Import> getImports() {
        return this.imports;
    }

    public Collection<Import> getAllImports() {
        HashMap<String, Import> allImports = new HashMap<String, Import>();
        this.getAllImports(allImports);
        return allImports.values();
    }

    private void getAllImports(Map<String, Import> allImports) {
        for (Import importInfo : this.imports) {
            if (allImports.get(importInfo.getName()) != null) continue;
            allImports.put(importInfo.getName(), importInfo);
            importInfo.getModule().getAllImports(allImports);
        }
    }

    public String toString() {
        return "Model [name=" + this.name + ", version=" + this.version + ", remoteClasses=" + this.remoteClasses + ", types=" + this.complexTypes + ", events=" + this.events + "]";
    }

    public void validateModule() {
        if (this.name == null) {
            throw new KurentoModuleCreatorException("Name is mandatory at least in one of the files");
        }
        if (this.kurentoVersion == null) {
            if (AUTO_IMPORTED_MODULES.contains(this.name)) {
                this.kurentoVersion = this.version;
            } else {
                throw new KurentoModuleCreatorException("Kurento version is mandatory at least in one of the files describing: " + this.name);
            }
        }
        if (this.version == null) {
            throw new KurentoModuleCreatorException("Version is mandatory at least in one of the files");
        }
        if (VersionManager.isReleaseVersion(this.version)) {
            for (Import importInfo : this.imports) {
                if (VersionManager.isReleaseVersion(importInfo.getVersion())) continue;
                throw new KurentoModuleCreatorException("All dependencies of a release version must be also release versions. Import '" + importInfo.getName() + "' is in non release version " + importInfo.getVersion());
            }
        }
    }

    public void resolveModel() {
        this.resolveModule(null);
    }

    public void resolveModule(ModuleManager moduleManager) {
        this.setModuleToTypes();
        if (this.resolutionState == ResolutionState.IN_PROCESS) {
            throw new KurentoModuleCreatorException("Found a dependency cycle in plugin '" + this.name + "'");
        }
        if (this.resolutionState == ResolutionState.RESOLVED) {
            log.debug("Module '" + this.name + "' yet resolved");
            return;
        }
        log.debug("Resolving module '" + this.name + "'");
        this.resolutionState = ResolutionState.IN_PROCESS;
        if (this.kurentoVersion == null && this.version != null) {
            this.kurentoVersion = this.version;
        }
        this.resolveImports(moduleManager);
        this.resolveTypes(moduleManager);
        this.addInfoForGeneration(moduleManager);
        log.debug("Module '" + this.name + "' resolved");
        this.resolutionState = ResolutionState.RESOLVED;
    }

    private void setModuleToTypes() {
        for (ComplexType complexType : this.complexTypes) {
            complexType.setModule(this);
        }
        for (RemoteClass remoteClass : this.remoteClasses) {
            remoteClass.setModule(this);
        }
        for (Event event : this.events) {
            event.setModule(this);
        }
    }

    private void addInfoForGeneration(ModuleManager moduleManager) {
        if (this.code == null) {
            this.code = new Code();
        }
        this.code.completeInfo(this, moduleManager);
    }

    private void resolveTypes(ModuleManager moduleManager) {
        this.remoteClassesMap = this.resolveNamedElements(this.remoteClasses);
        this.eventsMap = this.resolveNamedElements(this.events);
        this.complexTypesMap = this.resolveNamedElements(this.complexTypes);
        this.types = new HashMap<String, Type>();
        this.types.putAll(this.remoteClassesMap);
        this.types.putAll(this.eventsMap);
        this.types.putAll(this.complexTypesMap);
        this.put(this.types, BOOLEAN);
        this.put(this.types, STRING);
        this.put(this.types, INT);
        this.put(this.types, FLOAT);
        this.put(this.types, DOUBLE);
        this.put(this.types, INT64);
        this.allTypes = new HashMap<String, Type>(this.types);
        for (Import importEntry : this.imports) {
            this.allTypes.putAll(importEntry.getModule().getAllTypes());
        }
        this.resolveTypeRefs(this.remoteClasses, this.allTypes);
        this.resolveTypeRefs(this.events, this.allTypes);
        this.resolveTypeRefs(this.complexTypes, this.allTypes);
    }

    private void resolveImports(ModuleManager moduleManager) {
        this.autoImportModules(moduleManager);
        for (Import importEntry : this.imports) {
            ModuleDefinition dependencyModule = null;
            if (moduleManager != null) {
                dependencyModule = moduleManager.getModule(importEntry.getName());
            }
            if (dependencyModule == null) {
                throw new KurentoModuleCreatorException("Import '" + importEntry.getName() + "' not found in dependencies in any version");
            }
            if (!VersionManager.compatibleVersion(importEntry.getVersion(), dependencyModule.getVersion())) {
                if (VersionManager.devCompatibleVersion(importEntry.getVersion(), dependencyModule.getVersion())) {
                    log.info("[WARNING] Dependency on module '" + importEntry.getName() + "' version '" + importEntry.getVersion() + "' is satisfied with version '" + dependencyModule.getVersion() + "'");
                } else {
                    throw new KurentoModuleCreatorException("Import '" + importEntry.getName() + "' with version " + importEntry.getVersion() + " not found in dependencies, found version: " + dependencyModule.getVersion());
                }
            }
            dependencyModule.resolveModule(moduleManager);
            importEntry.setModule(dependencyModule);
            if (importEntry.getMavenVersion() == null) {
                importEntry.setMavenVersion(VersionManager.convertToMavenImport(importEntry.getVersion()));
            }
            if (importEntry.getNpmVersion() != null) continue;
            importEntry.setNpmVersion(VersionManager.convertToNpmImport(dependencyModule.getCode().getApi().get("js").get("npmGit"), importEntry.getVersion()));
        }
    }

    private void autoImportModules(ModuleManager moduleManager) {
        if (!CORE_MODULE.equals(this.name)) {
            this.imports.add(new Import(CORE_MODULE, this.kurentoVersion, this.kurentoMavenVersion, this.kurentoNpmVersion));
            if (!ELEMENTS_MODULE.equals(this.name)) {
                this.imports.add(new Import(ELEMENTS_MODULE, this.kurentoVersion, this.kurentoMavenVersion, this.kurentoNpmVersion));
                if (!FILTERS_MODULE.equals(this.name)) {
                    this.imports.add(new Import(FILTERS_MODULE, this.kurentoVersion, this.kurentoMavenVersion, this.kurentoNpmVersion));
                }
            }
        }
    }

    private Map<String, ? extends Type> getAllTypes() {
        return this.allTypes;
    }

    private void put(Map<String, ? super Type> types, Type t) {
        types.put(t.getName(), t);
    }

    private void resolveTypeRefs(List<? extends ModelElement> moduleElements, Map<String, Type> types) {
        for (ModelElement modelElement : moduleElements) {
            if (modelElement instanceof TypeRef) {
                this.resolveTypeRef((TypeRef)modelElement, types);
                continue;
            }
            if (modelElement == null) continue;
            this.resolveTypeRefs(modelElement.getChildren(), types);
        }
    }

    private void resolveTypeRef(TypeRef typeRef, Map<String, Type> types) {
        Type type = types.get(typeRef.getQualifiedName());
        if (type == null) {
            if (typeRef.getModuleName() == null) {
                typeRef.setModuleName(this.name);
                type = types.get(typeRef.getQualifiedName());
                if (type == null) {
                    throw new KurentoModuleCreatorException("The type '" + typeRef.getName() + "' is not defined in module " + this.name + " neither in kurento. Used in module: " + this.name + ".\nThe available types are: " + types.keySet());
                }
            } else {
                throw new KurentoModuleCreatorException("The type '" + typeRef.getName() + "' is not defined in module " + typeRef.getModuleName() + ". Used in module: " + this.name + ".\nThe available types are: " + types.keySet());
            }
        }
        typeRef.setType(type);
    }

    private <T extends NamedElement> Map<String, T> resolveNamedElements(List<? extends T> elements) {
        HashMap<String, NamedElement> elementsMap = new HashMap<String, NamedElement>();
        for (NamedElement element : elements) {
            if (AUTO_IMPORTED_MODULES.contains(this.name)) {
                elementsMap.put(element.getName(), element);
                continue;
            }
            elementsMap.put(this.name + "." + element.getName(), element);
        }
        return elementsMap;
    }

    public void expandMethodsWithOpsParams() {
        for (RemoteClass remoteClass : this.remoteClassesMap.values()) {
            remoteClass.expandMethodsWithOpsParams();
        }
    }

    public void fusionModules(ModuleDefinition module) {
        if (this.name == null) {
            this.name = module.name;
        } else if (module.name != null) {
            throw new KurentoModuleCreatorException("Name can only be set in one kmd file");
        }
        if (this.kurentoVersion == null) {
            this.kurentoVersion = module.kurentoVersion;
        } else if (module.kurentoVersion != null) {
            throw new KurentoModuleCreatorException("Kurento version can only be set in one kmd file");
        }
        if (this.version == null) {
            this.version = module.version;
        } else if (module.version != null) {
            throw new KurentoModuleCreatorException("Version can only be set in one kmd file");
        }
        if (this.imports.isEmpty()) {
            this.imports = module.imports;
        } else if (!module.imports.isEmpty()) {
            throw new KurentoModuleCreatorException("Imports section can only be set in one kmd file");
        }
        if (this.code == null) {
            this.code = module.code;
        } else if (module.code != null) {
            throw new KurentoModuleCreatorException("Code section can only be set in one kmd file");
        }
        this.complexTypes.addAll(module.complexTypes);
        this.remoteClasses.addAll(module.remoteClasses);
        this.events.addAll(module.events);
    }

    public boolean hasKmdSection() {
        if (this.code == null) {
            return false;
        }
        return this.code.getKmd() != null;
    }

    private static enum ResolutionState {
        NO_RESOLVED,
        IN_PROCESS,
        RESOLVED;

    }
}

