/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.modulecreator.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.kurento.modulecreator.definition.Method;
import org.kurento.modulecreator.definition.Property;
import org.kurento.modulecreator.definition.RemoteClass;
import org.kurento.modulecreator.definition.TypeRef;

public class RemoteClassAdapter
implements JsonSerializer<RemoteClass>,
JsonDeserializer<RemoteClass> {
    public JsonElement serialize(RemoteClass src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        if (src.getName() != null) {
            object.addProperty("name", src.getName());
        }
        if (src.getDoc() != null) {
            object.addProperty("doc", src.getDoc());
        }
        if (src.isAbstract()) {
            object.add("abstract", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        if (src.getExtends() != null) {
            object.add("extends", context.serialize((Object)src.getExtends()));
        }
        if (src.getConstructor() != null) {
            object.add("constructor", context.serialize((Object)src.getConstructor()));
        }
        if (!src.getProperties().isEmpty()) {
            object.add("properties", context.serialize(src.getProperties()));
        }
        if (!src.getMethods().isEmpty()) {
            object.add("methods", context.serialize(src.getMethods()));
        }
        if (!src.getEvents().isEmpty()) {
            object.add("events", context.serialize(src.getEvents()));
        }
        return object;
    }

    public RemoteClass deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = (JsonObject)json;
        String name = null;
        String doc = null;
        boolean abstractValue = false;
        TypeRef extendsValue = null;
        Method constructor = null;
        ArrayList<Method> methods = new ArrayList();
        ArrayList<Property> properties = new ArrayList();
        List<TypeRef> events = new ArrayList<TypeRef>();
        if (object.get("name") != null) {
            name = object.get("name").getAsString();
        }
        if (object.get("doc") != null) {
            doc = object.get("doc").getAsString();
        }
        if (object.get("abstract") != null) {
            abstractValue = object.get("abstract").getAsBoolean();
        }
        if (object.get("extends") != null) {
            extendsValue = (TypeRef)context.deserialize(object.get("extends"), TypeRef.class);
        }
        if (object.get("constructor") != null) {
            constructor = (Method)context.deserialize(object.get("constructor"), new TypeToken<Method>(){}.getType());
        }
        if (object.get("methods") != null) {
            methods = (List)context.deserialize(object.get("methods"), new TypeToken<List<Method>>(){}.getType());
        }
        if (object.get("properties") != null) {
            properties = (List)context.deserialize(object.get("properties"), new TypeToken<List<Property>>(){}.getType());
        }
        if (object.get("events") != null) {
            events = (List)context.deserialize(object.get("events"), new TypeToken<List<TypeRef>>(){}.getType());
        }
        RemoteClass remoteClass = new RemoteClass(name, doc, extendsValue, constructor, methods, properties, events);
        remoteClass.setAbstract(abstractValue);
        return remoteClass;
    }
}

