/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.async;

import com.github.dockerjava.api.async.ResultCallback;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultCallbackTemplate<RC_T extends ResultCallback<A_RES_T>, A_RES_T>
implements ResultCallback<A_RES_T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultCallbackTemplate.class);
    private final CountDownLatch completed = new CountDownLatch(1);
    private Closeable stream;
    private boolean closed = false;

    @Override
    public void onStart(Closeable stream) {
        this.stream = stream;
        this.closed = false;
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.closed) {
            return;
        }
        try {
            LOGGER.error("Error during callback", throwable);
            throw new RuntimeException(throwable);
        }
        catch (Throwable throwable2) {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            throw throwable2;
        }
    }

    @Override
    public void onComplete() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.stream != null) {
            this.stream.close();
        }
        this.completed.countDown();
    }

    public RC_T awaitCompletion() throws InterruptedException {
        this.completed.await();
        return (RC_T)this;
    }

    public RC_T awaitCompletion(long timeout, TimeUnit timeUnit) throws InterruptedException {
        this.completed.await(timeout, timeUnit);
        return (RC_T)this;
    }
}

