/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.test;

import java.awt.Color;
import java.awt.Paint;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.AxisChartDataSet;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.DataSeries;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.PropertyException;
import org.jCharts.properties.StackedBarChartProperties;
import org.jCharts.test.AxisChartTestBase;
import org.jCharts.test.ChartTestDriver;
import org.jCharts.test.TestDataGenerator;
import org.jCharts.types.ChartType;

public class StackedBarTestDriver
extends AxisChartTestBase {
    boolean supportsImageMap() {
        return true;
    }

    DataSeries getDataSeries() throws ChartDataException {
        int n = (int)TestDataGenerator.getRandomNumber(1.0, 30.0);
        int n2 = (int)TestDataGenerator.getRandomNumber(1.0, 5.0);
        DataSeries dataSeries = super.createDataSeries(n);
        StackedBarChartProperties stackedBarChartProperties = new StackedBarChartProperties();
        AxisChartDataSet axisChartDataSet = super.createAxisChartDataSet(ChartType.BAR_STACKED, stackedBarChartProperties, n2, n, 0, 5000);
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        return dataSeries;
    }

    public static void main(String[] stringArray) throws PropertyException, ChartDataException {
        StackedBarChartProperties stackedBarChartProperties = new StackedBarChartProperties();
        double[][] dArrayArray = new double[][]{{280.0, 16.0, 150.0, 90.0, 60.0, 200.0, 150.0, 60.0}, {80.0, 216.0, 10.0, 30.0, 15.0, 90.0, 150.0, 87.0}};
        Paint[] paintArray = new Paint[]{Color.yellow, Color.blue};
        String[] stringArray2 = new String[]{"Test Legend Label", "second set"};
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet(dArrayArray, stringArray2, paintArray, ChartType.BAR_STACKED, stackedBarChartProperties);
        String[] stringArray3 = new String[]{"1900", "1950", "2000", "2050", "3000", "3050", "4000", "4050"};
        DataSeries dataSeries = new DataSeries(stringArray3, "Cookies", "Years", "Effort Over Time");
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        ChartProperties chartProperties = new ChartProperties();
        AxisProperties axisProperties = new AxisProperties(false);
        axisProperties.getXAxisProperties().getAxisTitleChartFont();
        LegendProperties legendProperties = new LegendProperties();
        AxisChart axisChart = new AxisChart(dataSeries, chartProperties, axisProperties, legendProperties, 500, 400);
        axisChart.renderWithImageMap();
        ChartTestDriver.exportImage(axisChart, "StackedBarChartTest.png");
    }
}

