/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.maven;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.kurento.maven.ModuleMavenArtifact;
import org.kurento.modulecreator.KurentoModuleCreatorException;

public class KurentoDependencyManager {
    private Map<String, ModuleMavenArtifact> dependencies = new HashMap<String, ModuleMavenArtifact>();
    private Log log;

    public KurentoDependencyManager(Log log) {
        this.log = log;
    }

    public Collection<ModuleMavenArtifact> getDependencies() {
        return this.dependencies.values();
    }

    public ModuleMavenArtifact getDependency(String name) {
        return this.dependencies.get(name);
    }

    public void loadDependencies(MavenProject project) throws MojoExecutionException {
        this.log.info((CharSequence)"Searching for kurento dependencies:");
        for (Object artObj : project.getArtifacts()) {
            try {
                Artifact artifact = (Artifact)artObj;
                this.log.debug((CharSequence)("Exploring dependency: " + artifact));
                ModuleMavenArtifact kurentoArtifact = new ModuleMavenArtifact(this.log, artifact);
                if (!kurentoArtifact.isKurentoModule()) continue;
                this.log.info((CharSequence)("  Found kurento dependency in artifact: " + kurentoArtifact.getArtifactCoordinate()));
                this.addModuleMavenArtifact(kurentoArtifact);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Exception accessing to dependencies", (Exception)e);
            }
        }
    }

    private void addModuleMavenArtifact(ModuleMavenArtifact moduleMavenArtifact) {
        String moduleName = moduleMavenArtifact.getName();
        if (this.dependencies.containsKey(moduleName)) {
            throw new KurentoModuleCreatorException("Dependency " + moduleMavenArtifact.getArtifactCoordinate() + " has the same module '" + moduleName + "' that other dependency");
        }
        this.dependencies.put(moduleName, moduleMavenArtifact);
    }
}

