/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.ModuleController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.control.gui.TreeNodeWrapper;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class ModuleControllerGui
extends AbstractControllerGui
implements ActionListener {
    private static final long serialVersionUID = 240L;
    private JMeterTreeNode selected = null;
    private final JComboBox nodes;
    private final DefaultComboBoxModel nodesModel = new DefaultComboBoxModel();
    private final JLabel warningLabel;
    private JButton expandButton;

    public ModuleControllerGui() {
        this.nodes = new JComboBox(this.nodesModel);
        this.warningLabel = new JLabel("");
        this.init();
    }

    public String getLabelResource() {
        return "module_controller_title";
    }

    public void configure(TestElement el) {
        super.configure(el);
        ModuleController controller = (ModuleController)el;
        this.selected = controller.getSelectedNode();
        if (this.selected == null && controller.getNodePath() != null) {
            this.warningLabel.setText(JMeterUtils.getResString((String)"module_controller_warning") + this.renderPath(controller.getNodePath()));
        } else {
            this.warningLabel.setText("");
        }
        this.reinitialize();
    }

    private String renderPath(Collection<?> path) {
        Iterator<?> iter = path.iterator();
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
                iter.next();
                continue;
            }
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(" > ");
        }
        return buf.toString();
    }

    public TestElement createTestElement() {
        ModuleController mc = new ModuleController();
        this.configureTestElement((TestElement)mc);
        if (this.selected != null) {
            mc.setSelectedNode(this.selected);
        }
        return mc;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        TreeNodeWrapper tnw = (TreeNodeWrapper)this.nodesModel.getSelectedItem();
        if (tnw != null && tnw.getTreeNode() != null) {
            this.selected = tnw.getTreeNode();
            if (this.selected != null) {
                ((ModuleController)element).setSelectedNode(this.selected);
            }
        }
    }

    public void clearGui() {
        super.clearGui();
        this.nodes.setSelectedIndex(-1);
        this.selected = null;
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenu addMenu = MenuFactory.makeMenus((String[])new String[]{"menu_config_element", "menu_assertions", "menu_timer", "menu_listener"}, (String)JMeterUtils.getResString((String)"add"), (String)"Add");
        menu.add(addMenu);
        MenuFactory.addEditMenu((JPopupMenu)menu, (boolean)true);
        MenuFactory.addFileMenu((JPopupMenu)menu);
        return menu;
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 3, 1));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        JPanel modulesPanel = new JPanel();
        modulesPanel.setLayout(new BoxLayout(modulesPanel, 0));
        JLabel nodesLabel = new JLabel(JMeterUtils.getResString((String)"module_controller_module_to_run"));
        modulesPanel.add(nodesLabel);
        modulesPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        nodesLabel.setLabelFor(this.nodes);
        this.reinitialize();
        modulesPanel.add(this.nodes);
        modulesPanel.add(this.warningLabel);
        modulesPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.expandButton = new JButton(JMeterUtils.getResString((String)"expand"));
        this.expandButton.addActionListener(this);
        modulesPanel.add(this.expandButton);
        this.add(modulesPanel);
    }

    private void reinitialize() {
        this.nodesModel.removeAllElements();
        GuiPackage gp = GuiPackage.getInstance();
        if (gp != null) {
            JMeterTreeNode root = (JMeterTreeNode)GuiPackage.getInstance().getTreeModel().getRoot();
            this.buildNodesModel(root, "", 0);
        }
        if (this.selected != null) {
            for (int i = 0; i < this.nodesModel.getSize(); ++i) {
                TreeNodeWrapper current = (TreeNodeWrapper)this.nodesModel.getElementAt(i);
                if (current.getTreeNode() == null || !current.getTreeNode().equals(this.selected)) continue;
                this.nodesModel.setSelectedItem(current);
                break;
            }
        }
    }

    private void buildNodesModel(JMeterTreeNode node, String parent_name, int level) {
        if (level == 0 && (parent_name == null || parent_name.length() == 0)) {
            this.nodesModel.addElement(new TreeNodeWrapper(null, ""));
        }
        String separator = " > ";
        if (node != null) {
            StringBuilder name = new StringBuilder();
            for (int i = 0; i < node.getChildCount(); ++i) {
                name.setLength(0);
                JMeterTreeNode cur = (JMeterTreeNode)node.getChildAt(i);
                TestElement te = cur.getTestElement();
                if (te instanceof AbstractThreadGroup) {
                    name.append(parent_name);
                    name.append(cur.getName());
                    name.append(separator);
                    this.buildNodesModel(cur, name.toString(), level);
                    continue;
                }
                if (te instanceof Controller && !(te instanceof ModuleController)) {
                    name.append(parent_name);
                    name.append(cur.getName());
                    TreeNodeWrapper tnw = new TreeNodeWrapper(cur, name.toString());
                    this.nodesModel.addElement(tnw);
                    name.append(separator);
                    this.buildNodesModel(cur, name.toString(), level + 1);
                    continue;
                }
                if (!(te instanceof TestPlan) && !(te instanceof WorkBench)) continue;
                name.append(cur.getName());
                name.append(separator);
                this.buildNodesModel(cur, name.toString(), 0);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.expandButton) {
            JMeterTreeNode currentSelectedNode = null;
            TreeNodeWrapper tnw = (TreeNodeWrapper)this.nodesModel.getSelectedItem();
            if (tnw != null && tnw.getTreeNode() != null) {
                currentSelectedNode = tnw.getTreeNode();
            }
            if (currentSelectedNode != null) {
                this.expandToSelectNode(currentSelectedNode);
            }
            return;
        }
    }

    protected void expandToSelectNode(JMeterTreeNode selected) {
        GuiPackage guiInstance = GuiPackage.getInstance();
        JTree jTree = guiInstance.getMainFrame().getTree();
        jTree.expandPath(new TreePath(selected.getPath()));
        selected.setMarkedBySearch(true);
    }
}

