/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util;

public final class UnitConv {
    public static final float IN2MM = 25.4f;
    public static final float IN2CM = 2.54f;
    public static final int IN2PT = 72;

    public static double mm2pt(double mm) {
        return mm * 72.0 / (double)25.4f;
    }

    public static double mm2mpt(double mm) {
        return mm * 1000.0 * 72.0 / (double)25.4f;
    }

    public static double pt2mm(double pt) {
        return pt * (double)25.4f / 72.0;
    }

    public static double mm2in(double mm) {
        return mm / (double)25.4f;
    }

    public static double in2mm(double in) {
        return in * (double)25.4f;
    }

    public static double in2mpt(double in) {
        return in * 72.0 * 1000.0;
    }

    public static double in2pt(double in) {
        return in * 72.0;
    }

    public static double mpt2in(double mpt) {
        return mpt / 72.0 / 1000.0;
    }

    public static double mm2px(double mm, int resolution) {
        return UnitConv.mm2in(mm) * (double)resolution;
    }

    public static double mpt2px(double mpt, int resolution) {
        return UnitConv.mpt2in(mpt) * (double)resolution;
    }
}

