/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.poi.hdgf.extractor.VisioTextExtractor;
import org.apache.poi.hpbf.extractor.PublisherTextExtractor;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.microsoft.ExcelExtractor;
import org.apache.tika.parser.microsoft.HSLFExtractor;
import org.apache.tika.parser.microsoft.OutlookExtractor;
import org.apache.tika.parser.microsoft.POIFSContainerDetector;
import org.apache.tika.parser.microsoft.SummaryExtractor;
import org.apache.tika.parser.microsoft.WordExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfficeParser
extends AbstractParser {
    private static final long serialVersionUID = 7393462244028653479L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(POIFSDocumentType.access$000(POIFSDocumentType.WORKBOOK), POIFSDocumentType.access$000(POIFSDocumentType.OLE10_NATIVE), POIFSDocumentType.access$000(POIFSDocumentType.WORDDOCUMENT), POIFSDocumentType.access$000(POIFSDocumentType.UNKNOWN), POIFSDocumentType.access$000(POIFSDocumentType.ENCRYPTED), POIFSDocumentType.access$000(POIFSDocumentType.POWERPOINT), POIFSDocumentType.access$000(POIFSDocumentType.PUBLISHER), POIFSDocumentType.access$000(POIFSDocumentType.PROJECT), POIFSDocumentType.access$000(POIFSDocumentType.VISIO), POIFSDocumentType.access$000(POIFSDocumentType.XLR), POIFSDocumentType.access$000(POIFSDocumentType.OUTLOOK))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        Object container;
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        TikaInputStream tstream = TikaInputStream.cast((InputStream)stream);
        DirectoryNode root = tstream == null ? new NPOIFSFileSystem((InputStream)new CloseShieldInputStream(stream)).getRoot() : ((container = tstream.getOpenContainer()) instanceof NPOIFSFileSystem ? ((NPOIFSFileSystem)container).getRoot() : (container instanceof DirectoryNode ? (DirectoryNode)container : (tstream.hasFile() ? new NPOIFSFileSystem(tstream.getFileChannel()).getRoot() : new NPOIFSFileSystem((InputStream)new CloseShieldInputStream((InputStream)tstream)).getRoot())));
        this.parse(root, context, metadata, xhtml);
        xhtml.endDocument();
    }

    protected void parse(DirectoryNode root, ParseContext context, Metadata metadata, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        new SummaryExtractor(metadata).parseSummaries(root);
        POIFSDocumentType type = POIFSDocumentType.detectType((DirectoryEntry)root);
        if (type != POIFSDocumentType.UNKNOWN) {
            this.setType(metadata, type.getType());
        }
        switch (type) {
            case PUBLISHER: {
                PublisherTextExtractor publisherTextExtractor = new PublisherTextExtractor(root);
                xhtml.element("p", publisherTextExtractor.getText());
                break;
            }
            case WORDDOCUMENT: {
                new WordExtractor(context).parse(root, xhtml);
                break;
            }
            case POWERPOINT: {
                new HSLFExtractor(context).parse(root, xhtml);
                break;
            }
            case WORKBOOK: 
            case XLR: {
                Locale locale = (Locale)context.get(Locale.class, (Object)Locale.getDefault());
                new ExcelExtractor(context).parse(root, xhtml, locale);
                break;
            }
            case PROJECT: {
                break;
            }
            case VISIO: {
                VisioTextExtractor visioTextExtractor = new VisioTextExtractor(root);
                for (String text : visioTextExtractor.getAllText()) {
                    xhtml.element("p", text);
                }
                break;
            }
            case OUTLOOK: {
                OutlookExtractor extractor = new OutlookExtractor(root, context);
                extractor.parse(xhtml, metadata);
                break;
            }
            case ENCRYPTED: {
                EncryptionInfo info = new EncryptionInfo(root);
                Decryptor d = Decryptor.getInstance((EncryptionInfo)info);
                try {
                    String password = "VelvetSweatshop";
                    PasswordProvider passwordProvider = (PasswordProvider)context.get(PasswordProvider.class);
                    if (passwordProvider != null) {
                        password = passwordProvider.getPassword(metadata);
                    }
                    if (!d.verifyPassword(password)) {
                        throw new EncryptedDocumentException();
                    }
                    OOXMLParser parser = new OOXMLParser();
                    parser.parse(d.getDataStream(root), (ContentHandler)new EmbeddedContentHandler((ContentHandler)new BodyContentHandler((ContentHandler)xhtml)), metadata, context);
                    break;
                }
                catch (GeneralSecurityException ex) {
                    throw new EncryptedDocumentException((Throwable)ex);
                }
            }
        }
    }

    private void setType(Metadata metadata, MediaType type) {
        metadata.set("Content-Type", type.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum POIFSDocumentType {
        WORKBOOK("xls", MediaType.application((String)"vnd.ms-excel")),
        OLE10_NATIVE("ole", POIFSContainerDetector.OLE10_NATIVE),
        COMP_OBJ("ole", POIFSContainerDetector.COMP_OBJ),
        WORDDOCUMENT("doc", MediaType.application((String)"msword")),
        UNKNOWN("unknown", MediaType.application((String)"x-tika-msoffice")),
        ENCRYPTED("ole", MediaType.application((String)"x-tika-ooxml-protected")),
        POWERPOINT("ppt", MediaType.application((String)"vnd.ms-powerpoint")),
        PUBLISHER("pub", MediaType.application((String)"x-mspublisher")),
        PROJECT("mpp", MediaType.application((String)"vnd.ms-project")),
        VISIO("vsd", MediaType.application((String)"vnd.visio")),
        WORKS("wps", MediaType.application((String)"vnd.ms-works")),
        XLR("xlr", MediaType.application((String)"x-tika-msworks-spreadsheet")),
        OUTLOOK("msg", MediaType.application((String)"vnd.ms-outlook"));

        private final String extension;
        private final MediaType type;

        private POIFSDocumentType(String extension, MediaType type) {
            this.extension = extension;
            this.type = type;
        }

        public String getExtension() {
            return this.extension;
        }

        public MediaType getType() {
            return this.type;
        }

        public static POIFSDocumentType detectType(POIFSFileSystem fs) {
            return POIFSDocumentType.detectType((DirectoryEntry)fs.getRoot());
        }

        public static POIFSDocumentType detectType(NPOIFSFileSystem fs) {
            return POIFSDocumentType.detectType((DirectoryEntry)fs.getRoot());
        }

        public static POIFSDocumentType detectType(DirectoryEntry node) {
            HashSet<String> names = new HashSet<String>();
            for (Entry entry : node) {
                names.add(entry.getName());
            }
            MediaType type = POIFSContainerDetector.detect(names, node);
            for (POIFSDocumentType poifsType : POIFSDocumentType.values()) {
                if (!type.equals((Object)poifsType.type)) continue;
                return poifsType;
            }
            return UNKNOWN;
        }

        static /* synthetic */ MediaType access$000(POIFSDocumentType x0) {
            return x0.type;
        }
    }
}

