/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui.action;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.report.gui.tree.ReportTreeNode;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ReportEnableComponent
implements Command {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String ENABLE = "enable";
    public static final String DISABLE = "disable";
    private static final Set<String> commands = new HashSet<String>();

    public void doAction(ActionEvent e) {
        ReportTreeNode[] nodes = ReportGuiPackage.getInstance().getTreeListener().getSelectedNodes();
        if (e.getActionCommand().equals(ENABLE)) {
            log.debug("enabling currently selected gui objects");
            this.enableComponents(nodes, true);
        } else if (e.getActionCommand().equals(DISABLE)) {
            log.debug("disabling currently selected gui objects");
            this.enableComponents(nodes, false);
        }
    }

    private void enableComponents(ReportTreeNode[] nodes, boolean enable) {
        ReportGuiPackage pack = ReportGuiPackage.getInstance();
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i].setEnabled(enable);
            pack.getGui(nodes[i].getTestElement()).setEnabled(enable);
        }
    }

    public Set<String> getActionNames() {
        return commands;
    }

    static {
        commands.add(ENABLE);
        commands.add(DISABLE);
    }
}

