/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.gui.tree;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.jmeter.control.gui.ReportGui;
import org.apache.jmeter.gui.ReportGuiPackage;
import org.apache.jmeter.gui.ReportMainFrame;
import org.apache.jmeter.report.gui.tree.ReportTreeModel;
import org.apache.jmeter.report.gui.tree.ReportTreeNode;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ReportTreeListener
implements TreeSelectionListener,
MouseListener,
KeyListener,
MouseMotionListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private TreePath currentPath;
    private ActionListener actionHandler;
    private ReportTreeModel model;
    private JTree tree;
    private boolean dragging = false;
    private ReportTreeNode[] draggedNodes;
    private JLabel dragIcon = new JLabel(JMeterUtils.getImage((String)"leafnode.gif"));

    public ReportTreeListener(ReportTreeModel model) {
        this.model = model;
        this.dragIcon.validate();
        this.dragIcon.setVisible(true);
    }

    public ReportTreeListener() {
        this.dragIcon.validate();
        this.dragIcon.setVisible(true);
    }

    public void setModel(ReportTreeModel m) {
        this.model = m;
    }

    public void setActionHandler(ActionListener ah) {
        this.actionHandler = ah;
    }

    public void setJTree(JTree tree) {
        this.tree = tree;
    }

    public void setEndWindow(Container window) {
    }

    public JTree getJTree() {
        return this.tree;
    }

    public ReportTreeNode getCurrentNode() {
        if (this.currentPath != null) {
            if (this.currentPath.getLastPathComponent() != null) {
                return (ReportTreeNode)this.currentPath.getLastPathComponent();
            }
            return (ReportTreeNode)this.currentPath.getParentPath().getLastPathComponent();
        }
        return (ReportTreeNode)this.model.getRoot();
    }

    public ReportTreeNode[] getSelectedNodes() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null) {
            return new ReportTreeNode[]{this.getCurrentNode()};
        }
        ReportTreeNode[] nodes = new ReportTreeNode[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            nodes[i] = (ReportTreeNode)paths[i].getLastPathComponent();
        }
        return nodes;
    }

    public TreePath removedSelectedNode() {
        this.currentPath = this.currentPath.getParentPath();
        return this.currentPath;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        log.debug("value changed, updating currentPath");
        this.currentPath = e.getNewLeadSelectionPath();
        this.actionHandler.actionPerformed(new ActionEvent(this, 3333, "edit"));
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.dragging && this.isValidDragAction(this.draggedNodes, this.getCurrentNode())) {
            this.dragging = false;
            JPopupMenu dragNdrop = new JPopupMenu();
            JMenuItem item = new JMenuItem(JMeterUtils.getResString((String)"Insert Before"));
            item.addActionListener(this.actionHandler);
            item.setActionCommand("drag_n_drop.insert_before");
            dragNdrop.add(item);
            item = new JMenuItem(JMeterUtils.getResString((String)"Insert After"));
            item.addActionListener(this.actionHandler);
            item.setActionCommand("drag_n_drop.insert_after");
            dragNdrop.add(item);
            item = new JMenuItem(JMeterUtils.getResString((String)"Add as Child"));
            item.addActionListener(this.actionHandler);
            item.setActionCommand("drag_n_drop.add");
            dragNdrop.add(item);
            dragNdrop.addSeparator();
            item = new JMenuItem(JMeterUtils.getResString((String)"Cancel"));
            dragNdrop.add(item);
            this.displayPopUp(e, dragNdrop);
        } else {
            ReportGuiPackage.getInstance().getMainFrame().repaint();
        }
        this.dragging = false;
    }

    public ReportTreeNode[] getDraggedNodes() {
        return this.draggedNodes;
    }

    private boolean isValidDragAction(ReportTreeNode[] source, ReportTreeNode dest) {
        boolean isValid = true;
        TreeNode[] path = dest.getPath();
        for (int i = 0; i < path.length; ++i) {
            if (!this.contains(source, path[i])) continue;
            isValid = false;
        }
        return isValid;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    private void changeSelectionIfDragging(MouseEvent e) {
        if (this.dragging) {
            ReportGuiPackage.getInstance().getMainFrame().drawDraggedComponent(this.dragIcon, e.getX(), e.getY());
            if (this.tree.getPathForLocation(e.getX(), e.getY()) != null) {
                this.currentPath = this.tree.getPathForLocation(e.getX(), e.getY());
                if (!this.contains(this.draggedNodes, this.getCurrentNode())) {
                    this.tree.setSelectionPath(this.currentPath);
                }
            }
        }
    }

    private boolean contains(Object[] container, Object item) {
        for (int i = 0; i < container.length; ++i) {
            if (container[i] != item) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ReportMainFrame mainFrame = ReportGuiPackage.getInstance().getMainFrame();
        mainFrame.closeMenu();
        int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
        if (this.tree.getPathForLocation(e.getX(), e.getY()) != null) {
            log.debug("mouse pressed, updating currentPath");
            this.currentPath = this.tree.getPathForLocation(e.getX(), e.getY());
        }
        if (selRow != -1 && this.isRightClick(e)) {
            if (this.tree.getSelectionCount() < 2) {
                this.tree.setSelectionPath(this.currentPath);
            }
            if (this.getCurrentNode() != null) {
                log.debug("About to display pop-up");
                this.displayPopUp(e);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.dragging) {
            this.dragging = true;
            this.draggedNodes = this.getSelectedNodes();
            if (this.draggedNodes[0].getUserObject() instanceof ReportGui) {
                this.dragging = false;
            }
        }
        this.changeSelectionIfDragging(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private boolean isRightClick(MouseEvent e) {
        return e.isPopupTrigger() || (8 & e.getModifiers()) > 0 || 4 == e.getModifiers();
    }

    private void displayPopUp(MouseEvent e) {
        JPopupMenu pop = this.getCurrentNode().createPopupMenu();
        ReportGuiPackage.getInstance().displayPopUp(e, pop);
    }

    private void displayPopUp(MouseEvent e, JPopupMenu popup) {
        log.warn("Shouldn't be here");
        if (popup != null) {
            popup.pack();
            popup.show(this.tree, e.getX(), e.getY());
            popup.setVisible(true);
            popup.requestFocus();
        }
    }
}

