/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.branch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmBranchParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.branch.AbstractBranchCommand;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnJavaUtil;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class SvnJavaBranchCommand
extends AbstractBranchCommand
implements SvnCommand {
    protected ScmResult executeBranchCommand(ScmProviderRepository repo, ScmFileSet fileSet, String branch, ScmBranchParameters scmBranchParameters) throws ScmException {
        if (branch == null || StringUtils.isEmpty((String)branch.trim())) {
            throw new ScmException("branch name must be specified");
        }
        if (!fileSet.getFileList().isEmpty()) {
            throw new ScmException("This provider doesn't support branching subsets of a directory");
        }
        SvnScmProviderRepository repository = (SvnScmProviderRepository)repo;
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repo;
        try {
            SVNCommitInfo info;
            SVNURL destURL = SVNURL.parseURIEncoded((String)SvnTagBranchUtils.resolveBranchUrl((SvnScmProviderRepository)repository, (ScmBranch)new ScmBranch(branch)));
            String message = "[maven-scm] copy for branch " + branch;
            if (scmBranchParameters != null) {
                message = scmBranchParameters.getMessage();
            }
            if ((info = scmBranchParameters != null && scmBranchParameters.isRemoteBranching() ? SvnJavaUtil.copy(javaRepo.getClientManager(), javaRepo.getSvnUrl(), destURL, false, message, null) : SvnJavaUtil.copy(javaRepo.getClientManager(), fileSet.getBasedir(), destURL, false, message, null)).getErrorMessage() != null) {
                return new TagScmResult("JavaSVN Library", "SVN tag failed.", info.getErrorMessage().getMessage(), false);
            }
            ArrayList<ScmFile> fileList = new ArrayList<ScmFile>();
            List files = null;
            try {
                List listFiles;
                files = listFiles = FileUtils.getFiles((File)fileSet.getBasedir(), (String)"**", (String)"**/.svn/**", (boolean)false);
            }
            catch (IOException e) {
                throw new ScmException("Error while executing command.", (Throwable)e);
            }
            for (File f : files) {
                fileList.add(new ScmFile(f.getPath(), ScmFileStatus.TAGGED));
            }
            return new BranchScmResult("JavaSVN Library", fileList);
        }
        catch (SVNException e) {
            return new BranchScmResult("JavaSVN Library", "SVN tag failed.", e.getMessage(), false);
        }
    }

    public ScmResult executeBranchCommand(ScmProviderRepository repo, ScmFileSet fileSet, String branch, String message) throws ScmException {
        ScmBranchParameters scmBranchParameters = new ScmBranchParameters(message);
        return this.executeBranchCommand(repo, fileSet, branch, scmBranchParameters);
    }
}

