/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.export;

import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.export.AbstractExportCommand;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnCommandUtils;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.util.ScmFileEventHandler;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnJavaUtil;
import org.codehaus.plexus.util.StringUtils;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnJavaExportCommand
extends AbstractExportCommand
implements SvnCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExportScmResult executeExportCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version, String outputDirectory) throws ScmException {
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repo;
        ScmFileEventHandler handler = new ScmFileEventHandler(this.getLogger(), fileSet.getBasedir());
        javaRepo.getClientManager().getUpdateClient().setEventHandler((ISVNEventHandler)handler);
        String url = javaRepo.getUrl();
        if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
            if (version instanceof ScmTag) {
                url = SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)javaRepo, (ScmTag)((ScmTag)version));
            } else if (version instanceof ScmBranch) {
                url = SvnTagBranchUtils.resolveBranchUrl((SvnScmProviderRepository)javaRepo, (ScmBranch)((ScmBranch)version));
            }
        }
        url = SvnCommandUtils.fixUrl((String)url, (String)javaRepo.getUser());
        try {
            SvnJavaUtil.export(javaRepo.getClientManager(), SVNURL.parseURIEncoded((String)url), SVNRevision.HEAD, fileSet.getBasedir(), true);
            ExportScmResult exportScmResult = new ExportScmResult("JavaSVN Library", handler.getFiles());
            return exportScmResult;
        }
        catch (SVNException e) {
            ExportScmResult exportScmResult = new ExportScmResult("JavaSVN Library", "SVN checkout failed.", e.getMessage(), false);
            return exportScmResult;
        }
        finally {
            javaRepo.getClientManager().getUpdateClient().setEventHandler(null);
        }
    }
}

