/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.binary.Base64;
import org.linguafranca.pwdb.kdbx.SerializableDatabase;
import org.linguafranca.pwdb.kdbx.StreamEncryptor;
import org.linguafranca.pwdb.kdbx.dom.DomHelper;
import org.linguafranca.pwdb.kdbx.stream_3_1.Salsa20StreamEncryptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DomSerializableDatabase
implements SerializableDatabase {
    private Document doc;
    private StreamEncryptor encryption;
    private static final String protectQuery = "//Meta/MemoryProtection/Protect%s";
    private static final String pattern = "//String/Key[text()='%s']/following-sibling::Value";

    private DomSerializableDatabase() {
    }

    public static DomSerializableDatabase createEmptyDatabase() throws IOException {
        DomSerializableDatabase result = new DomSerializableDatabase();
        result.load(result.getClass().getClassLoader().getResourceAsStream("base.kdbx.xml"));
        try {
            String now = DomHelper.dateFormatter.format(new Date());
            NodeList list = (NodeList)DomHelper.xpath.evaluate("//*[contains(text(),'${creationDate}')]", result.doc.getDocumentElement(), XPathConstants.NODESET);
            for (int i = 0; i < list.getLength(); ++i) {
                list.item(i).setTextContent(now);
            }
            Node uuid = (Node)DomHelper.xpath.evaluate("//UUID", result.doc.getDocumentElement(), XPathConstants.NODE);
            uuid.setTextContent(DomHelper.base64RandomUuid());
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
        result.setEncryption((StreamEncryptor)new Salsa20StreamEncryptor(SecureRandom.getSeed(32)));
        return result;
    }

    public SerializableDatabase load(InputStream inputStream) throws IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            this.doc = dBuilder.parse(inputStream);
            NodeList protectedContent = (NodeList)DomHelper.xpath.evaluate("//*[@Protected='True']", this.doc, XPathConstants.NODESET);
            for (int i = 0; i < protectedContent.getLength(); ++i) {
                Element element = (Element)protectedContent.item(i);
                String base64 = DomHelper.getElementContent(".", element);
                byte[] encrypted = Base64.decodeBase64((byte[])base64.getBytes());
                String decrypted = new String(this.encryption.decrypt(encrypted), "UTF-8");
                DomHelper.setElementContent(".", element, decrypted);
                element.removeAttribute("Protected");
            }
            return this;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Instantiating Document Builder", e);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Parsing exception", e);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("XPath Exception", e);
        }
    }

    public void save(OutputStream outputStream) {
        Document copyDoc = (Document)this.doc.cloneNode(true);
        try {
            this.prepareProtection(copyDoc, "Title");
            this.prepareProtection(copyDoc, "UserName");
            this.prepareProtection(copyDoc, "Password");
            this.prepareProtection(copyDoc, "Notes");
            this.prepareProtection(copyDoc, "URL");
            NodeList protectedContent = (NodeList)DomHelper.xpath.evaluate("//*[@Protected='True']", copyDoc, XPathConstants.NODESET);
            for (int i = 0; i < protectedContent.getLength(); ++i) {
                Element element = (Element)protectedContent.item(i);
                String decrypted = DomHelper.getElementContent(".", element);
                if (decrypted == null) {
                    decrypted = "";
                }
                byte[] encrypted = this.encryption.encrypt(decrypted.getBytes());
                String base64 = new String(Base64.encodeBase64((byte[])encrypted));
                DomHelper.setElementContent(".", element, base64);
            }
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
        DOMSource xmlSource = new DOMSource(copyDoc);
        StreamResult outputTarget = new StreamResult(outputStream);
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(xmlSource, outputTarget);
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    private void prepareProtection(Document doc, String protect) throws XPathExpressionException {
        String query = String.format(protectQuery, protect);
        if (!((String)DomHelper.xpath.evaluate(query, doc, XPathConstants.STRING)).toLowerCase().equals("true")) {
            return;
        }
        String path = String.format(pattern, protect);
        NodeList nodelist = (NodeList)DomHelper.xpath.evaluate(path, doc, XPathConstants.NODESET);
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Element element = (Element)nodelist.item(i);
            element.setAttribute("Protected", "True");
        }
    }

    public byte[] getHeaderHash() {
        try {
            String base64 = (String)DomHelper.xpath.evaluate("//HeaderHash", this.doc, XPathConstants.STRING);
            return Base64.decodeBase64((byte[])base64.getBytes());
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("Can't get header hash", e);
        }
    }

    public void setHeaderHash(byte[] hash) {
        String base64String = new String(Base64.encodeBase64((byte[])hash));
        try {
            ((Element)DomHelper.xpath.evaluate("//HeaderHash", this.doc, XPathConstants.NODE)).setTextContent(base64String);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException("Can't set header hash", e);
        }
    }

    public StreamEncryptor getEncryption() {
        return this.encryption;
    }

    public void setEncryption(StreamEncryptor encryption) {
        this.encryption = encryption;
    }

    public Document getDoc() {
        return this.doc;
    }
}

