/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source.selector;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.selector.MethodSelector;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;
import org.mapstruct.ap.internal.prism.NamedPrism;
import org.mapstruct.ap.internal.prism.QualifierPrism;

public class QualifierSelector
implements MethodSelector {
    private final Types typeUtils;
    private final TypeMirror namedAnnotationTypeMirror;

    public QualifierSelector(Types typeUtils, Elements elementUtils) {
        this.typeUtils = typeUtils;
        this.namedAnnotationTypeMirror = elementUtils.getTypeElement("org.mapstruct.Named").asType();
    }

    @Override
    public <T extends Method> List<T> getMatchingMethods(Method mappingMethod, List<T> methods, Type sourceType, Type targetType, SelectionCriteria criteria) {
        int numberOfQualifiersToMatch = 0;
        ArrayList<TypeMirror> qualifierTypes = new ArrayList<TypeMirror>();
        if (criteria.getQualifiers() != null) {
            qualifierTypes.addAll(criteria.getQualifiers());
            numberOfQualifiersToMatch += criteria.getQualifiers().size();
        }
        ArrayList<String> qualfiedByNames = new ArrayList<String>();
        if (criteria.getQualifiedByNames() != null) {
            qualfiedByNames.addAll(criteria.getQualifiedByNames());
            numberOfQualifiersToMatch += criteria.getQualifiedByNames().size();
        }
        if (!qualfiedByNames.isEmpty()) {
            qualifierTypes.add(this.namedAnnotationTypeMirror);
        }
        if (qualifierTypes.isEmpty()) {
            ArrayList<Method> nonQualiferAnnotatedMethods = new ArrayList<Method>();
            for (Method candidate : methods) {
                if (candidate instanceof SourceMethod) {
                    Set<AnnotationMirror> qualifierAnnotations = this.getQualifierAnnotationMirrors(candidate);
                    if (!qualifierAnnotations.isEmpty()) continue;
                    nonQualiferAnnotatedMethods.add(candidate);
                    continue;
                }
                nonQualiferAnnotatedMethods.add(candidate);
            }
            return nonQualiferAnnotatedMethods;
        }
        ArrayList<Method> matches = new ArrayList<Method>();
        for (Method candidate : methods) {
            if (!(candidate instanceof SourceMethod)) continue;
            Set<AnnotationMirror> qualifierAnnotationMirrors = this.getQualifierAnnotationMirrors(candidate);
            int matchingQualifierCounter = 0;
            block2: for (AnnotationMirror qualifierAnnotationMirror : qualifierAnnotationMirrors) {
                for (TypeMirror qualifierType : qualifierTypes) {
                    DeclaredType qualifierAnnotationType;
                    if (!this.typeUtils.isSameType(qualifierType, qualifierAnnotationType = qualifierAnnotationMirror.getAnnotationType())) continue;
                    if (this.typeUtils.isSameType(qualifierAnnotationType, this.namedAnnotationTypeMirror)) {
                        NamedPrism namedPrism = NamedPrism.getInstance(qualifierAnnotationMirror);
                        if (namedPrism.value() == null || !qualfiedByNames.contains(namedPrism.value())) continue block2;
                        ++matchingQualifierCounter;
                        continue block2;
                    }
                    ++matchingQualifierCounter;
                    continue block2;
                }
            }
            if (matchingQualifierCounter != numberOfQualifiersToMatch) continue;
            matches.add(candidate);
        }
        if (!matches.isEmpty()) {
            return matches;
        }
        return methods;
    }

    private Set<AnnotationMirror> getQualifierAnnotationMirrors(Method candidate) {
        HashSet<AnnotationMirror> qualiferAnnotations = new HashSet<AnnotationMirror>();
        SourceMethod candidateSM = (SourceMethod)candidate;
        List<? extends AnnotationMirror> methodAnnotations = candidateSM.getExecutable().getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : methodAnnotations) {
            this.addOnlyWhenQualifier(qualiferAnnotations, annotationMirror);
        }
        Type mapper = candidate.getDeclaringMapper();
        if (mapper != null) {
            List<? extends AnnotationMirror> list = mapper.getTypeElement().getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : list) {
                this.addOnlyWhenQualifier(qualiferAnnotations, annotationMirror);
            }
        }
        return qualiferAnnotations;
    }

    private void addOnlyWhenQualifier(Set<AnnotationMirror> annotationSet, AnnotationMirror candidate) {
        if (QualifierPrism.getInstanceOn(candidate.getAnnotationType().asElement()) != null) {
            annotationSet.add(candidate);
        }
    }
}

