/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.mapstruct.ap.shaded.freemarker.core.BugException;
import org.mapstruct.ap.shaded.freemarker.core.ISOLikeTemplateDateFormatFactory;
import org.mapstruct.ap.shaded.freemarker.core.TemplateDateFormat;
import org.mapstruct.ap.shaded.freemarker.core.UnknownDateTypeFormattingUnsupportedException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateDateModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModelException;
import org.mapstruct.ap.shaded.freemarker.template.utility.DateUtil;
import org.mapstruct.ap.shaded.freemarker.template.utility.StringUtil;

abstract class ISOLikeTemplateDateFormat
extends TemplateDateFormat {
    private static final String XS_LESS_THAN_SECONDS_ACCURACY_ERROR_MESSAGE = "Less than seconds accuracy isn't allowed by the XML Schema format";
    private final ISOLikeTemplateDateFormatFactory factory;
    protected final int dateType;
    protected final boolean zonelessInput;
    protected final TimeZone timeZone;
    protected final Boolean forceUTC;
    protected final Boolean showZoneOffset;
    protected final int accuracy;

    public ISOLikeTemplateDateFormat(String settingValue, int parsingStart, int dateType, boolean zonelessInput, TimeZone timeZone, ISOLikeTemplateDateFormatFactory factory) throws ParseException, UnknownDateTypeFormattingUnsupportedException {
        this.factory = factory;
        if (dateType == 0) {
            throw new UnknownDateTypeFormattingUnsupportedException();
        }
        this.dateType = dateType;
        this.zonelessInput = zonelessInput;
        int ln = settingValue.length();
        boolean afterSeparator = false;
        int i = parsingStart;
        int accuracy = 7;
        Boolean showZoneOffset = null;
        Boolean forceUTC = Boolean.FALSE;
        while (i < ln) {
            char c;
            if ((c = settingValue.charAt(i++)) == '_' || c == ' ') {
                afterSeparator = true;
                continue;
            }
            if (!afterSeparator) {
                throw new ParseException("Missing space or \"_\" before \"" + c + "\"", i);
            }
            block0 : switch (c) {
                case 'h': 
                case 'm': 
                case 's': {
                    if (accuracy != 7) {
                        throw new ParseException("Character \"" + c + "\" is unexpected as accuracy was already specified earlier.", i);
                    }
                    switch (c) {
                        case 'h': {
                            if (this.isXSMode()) {
                                throw new ParseException(XS_LESS_THAN_SECONDS_ACCURACY_ERROR_MESSAGE, i);
                            }
                            accuracy = 4;
                            break;
                        }
                        case 'm': {
                            if (i < ln && settingValue.charAt(i) == 's') {
                                ++i;
                                accuracy = 8;
                                break;
                            }
                            if (this.isXSMode()) {
                                throw new ParseException(XS_LESS_THAN_SECONDS_ACCURACY_ERROR_MESSAGE, i);
                            }
                            accuracy = 5;
                            break;
                        }
                        case 's': {
                            accuracy = 6;
                        }
                    }
                    break;
                }
                case 'f': {
                    if (i < ln && settingValue.charAt(i) == 'u') {
                        this.checkForceUTCNotSet(forceUTC, i);
                        ++i;
                        forceUTC = Boolean.TRUE;
                        break;
                    }
                }
                case 'n': {
                    if (showZoneOffset != null) {
                        throw new ParseException("Character \"" + c + "\" is unexpected as zone offset visibility was already " + "specified earlier.", i);
                    }
                    switch (c) {
                        case 'n': {
                            if (i < ln && settingValue.charAt(i) == 'z') {
                                ++i;
                                showZoneOffset = Boolean.FALSE;
                                break block0;
                            }
                            throw new ParseException("\"n\" must be followed by \"z\"", i);
                        }
                        case 'f': {
                            if (i < ln && settingValue.charAt(i) == 'z') {
                                ++i;
                                showZoneOffset = Boolean.TRUE;
                                break block0;
                            }
                            throw new ParseException("\"f\" must be followed by \"z\"", i);
                        }
                    }
                    break;
                }
                case 'u': {
                    this.checkForceUTCNotSet(forceUTC, i);
                    forceUTC = null;
                    break;
                }
                default: {
                    throw new ParseException("Unexpected character, " + StringUtil.jQuote(String.valueOf(c)) + ". Expected the beginning of one of: h, m, s, ms, nz, fz, u", i);
                }
            }
            afterSeparator = false;
        }
        this.accuracy = accuracy;
        this.showZoneOffset = showZoneOffset;
        this.forceUTC = forceUTC;
        this.timeZone = timeZone;
    }

    private void checkForceUTCNotSet(Boolean fourceUTC, int i) throws ParseException {
        if (fourceUTC != Boolean.FALSE) {
            throw new ParseException("The UTC usage option was already set earlier.", i);
        }
    }

    public final String format(TemplateDateModel dateModel) throws TemplateModelException {
        Date date = dateModel.getAsDate();
        return this.format(date, this.dateType != 1, this.dateType != 2, this.showZoneOffset == null ? !this.zonelessInput : this.showZoneOffset, this.accuracy, (this.forceUTC == null ? !this.zonelessInput : this.forceUTC != false) ? DateUtil.UTC : this.timeZone, this.factory.getISOBuiltInCalendar());
    }

    protected abstract String format(Date var1, boolean var2, boolean var3, boolean var4, int var5, TimeZone var6, DateUtil.DateToISO8601CalendarFactory var7);

    public final Date parse(String s) throws ParseException {
        TimeZone tz;
        DateUtil.CalendarFieldsToDateConverter calToDateConverter = this.factory.getCalendarFieldsToDateCalculator();
        TimeZone timeZone = tz = this.forceUTC != Boolean.FALSE ? DateUtil.UTC : this.timeZone;
        if (this.dateType == 2) {
            return this.parseDate(s, tz, calToDateConverter);
        }
        if (this.dateType == 1) {
            return this.parseTime(s, tz, calToDateConverter);
        }
        if (this.dateType == 3) {
            return this.parseDateTime(s, tz, calToDateConverter);
        }
        throw new BugException("Unexpected date type: " + this.dateType);
    }

    protected abstract Date parseDate(String var1, TimeZone var2, DateUtil.CalendarFieldsToDateConverter var3) throws DateUtil.DateParseException;

    protected abstract Date parseTime(String var1, TimeZone var2, DateUtil.CalendarFieldsToDateConverter var3) throws DateUtil.DateParseException;

    protected abstract Date parseDateTime(String var1, TimeZone var2, DateUtil.CalendarFieldsToDateConverter var3) throws DateUtil.DateParseException;

    public final String getDescription() {
        switch (this.dateType) {
            case 2: {
                return this.getDateDescription();
            }
            case 1: {
                return this.getTimeDescription();
            }
            case 3: {
                return this.getDateTimeDescription();
            }
        }
        return "<error: wrong format dateType>";
    }

    protected abstract String getDateDescription();

    protected abstract String getTimeDescription();

    protected abstract String getDateTimeDescription();

    public final boolean isLocaleBound() {
        return false;
    }

    protected abstract boolean isXSMode();
}

