/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.ParameterBinding;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.builtin.BuiltInMethod;

public class MethodReference
extends MappingMethod
implements Assignment {
    private final MapperReference declaringMapper;
    private final Set<Type> importTypes;
    private final List<Type> thrownTypes;
    private final boolean isUpdateMethod;
    private final String contextParam;
    private Assignment assignment;
    private final Type definingType;
    private final List<ParameterBinding> parameterBindings;
    private final Parameter providingParameter;

    protected MethodReference(Method method, MapperReference declaringMapper, Parameter providingParameter, List<ParameterBinding> parameterBindings) {
        super(method);
        this.declaringMapper = declaringMapper;
        this.providingParameter = providingParameter;
        this.parameterBindings = parameterBindings;
        this.contextParam = null;
        HashSet<Type> imported = new HashSet<Type>();
        for (Type type : method.getThrownTypes()) {
            imported.addAll(type.getImportTypes());
        }
        for (ParameterBinding binding : parameterBindings) {
            imported.addAll(binding.getImportTypes());
        }
        this.importTypes = Collections.unmodifiableSet(imported);
        this.thrownTypes = method.getThrownTypes();
        this.isUpdateMethod = method.getMappingTargetParameter() != null;
        this.definingType = method.getDefiningType();
    }

    private MethodReference(BuiltInMethod method, ConversionContext contextParam) {
        super(method);
        this.declaringMapper = null;
        this.providingParameter = null;
        this.contextParam = method.getContextParameter(contextParam);
        this.importTypes = Collections.emptySet();
        this.thrownTypes = Collections.emptyList();
        this.definingType = null;
        this.isUpdateMethod = method.getMappingTargetParameter() != null;
        this.parameterBindings = ParameterBinding.fromParameters(method.getParameters());
    }

    public MapperReference getDeclaringMapper() {
        return this.declaringMapper;
    }

    public Parameter getProvidingParameter() {
        return this.providingParameter;
    }

    public String getMapperVariableName() {
        return this.declaringMapper.getVariableName();
    }

    public String getContextParam() {
        return this.contextParam;
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    @Override
    public void setAssignment(Assignment assignment) {
        this.assignment = assignment;
    }

    @Override
    public String getSourceReference() {
        return this.assignment.getSourceReference();
    }

    @Override
    public String getSourcePresenceCheckerReference() {
        return this.assignment.getSourcePresenceCheckerReference();
    }

    @Override
    public Type getSourceType() {
        return this.assignment.getSourceType();
    }

    @Override
    public String createLocalVarName(String desiredName) {
        return this.assignment.createLocalVarName(desiredName);
    }

    @Override
    public String getSourceLocalVarName() {
        return this.assignment.getSourceLocalVarName();
    }

    @Override
    public void setSourceLocalVarName(String sourceLocalVarName) {
        this.assignment.setSourceLocalVarName(sourceLocalVarName);
    }

    @Override
    public String getSourceParameterName() {
        return this.assignment.getSourceParameterName();
    }

    @Override
    public boolean isSourceReferenceParameter() {
        return this.assignment.isSourceReferenceParameter();
    }

    public Type getSingleSourceParameterType() {
        for (Parameter parameter : this.getSourceParameters()) {
            if (parameter.isTargetType()) continue;
            return parameter.getType();
        }
        return null;
    }

    public Type getDefiningType() {
        return this.definingType;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> imported = new HashSet<Type>(this.importTypes);
        if (this.assignment != null) {
            imported.addAll(this.assignment.getImportTypes());
        }
        if (this.isStatic()) {
            imported.add(this.definingType);
        }
        return imported;
    }

    @Override
    public List<Type> getThrownTypes() {
        ArrayList<Type> exceptions = new ArrayList<Type>();
        exceptions.addAll(this.thrownTypes);
        if (this.assignment != null) {
            exceptions.addAll(this.assignment.getThrownTypes());
        }
        return exceptions;
    }

    @Override
    public Assignment.AssignmentType getType() {
        switch (this.assignment.getType()) {
            case DIRECT: {
                return Assignment.AssignmentType.MAPPED;
            }
            case MAPPED: {
                return Assignment.AssignmentType.MAPPED_TWICE;
            }
            case TYPE_CONVERTED: {
                return Assignment.AssignmentType.TYPE_CONVERTED_MAPPED;
            }
        }
        return null;
    }

    @Override
    public boolean isCallingUpdateMethod() {
        return this.isUpdateMethod;
    }

    public List<ParameterBinding> getParameterBindings() {
        return this.parameterBindings;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.declaringMapper == null ? 0 : this.declaringMapper.hashCode());
        result = 31 * result + (this.providingParameter == null ? 0 : this.providingParameter.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodReference other = (MethodReference)obj;
        if (this.declaringMapper == null ? other.declaringMapper != null : !this.declaringMapper.equals(other.declaringMapper)) {
            return false;
        }
        return !(this.providingParameter == null ? other.providingParameter != null : !this.providingParameter.equals(other.providingParameter));
    }

    public static MethodReference forBuiltInMethod(BuiltInMethod method, ConversionContext contextParam) {
        return new MethodReference(method, contextParam);
    }

    public static MethodReference forForgedMethod(Method method, List<ParameterBinding> parameterBindings) {
        return new MethodReference(method, null, null, parameterBindings);
    }

    public static MethodReference forParameterProvidedMethod(Method method, Parameter providingParameter, List<ParameterBinding> parameterBindings) {
        return new MethodReference(method, null, providingParameter, parameterBindings);
    }

    public static MethodReference forMapperReference(Method method, MapperReference declaringMapper, List<ParameterBinding> parameterBindings) {
        return new MethodReference(method, declaringMapper, null, parameterBindings);
    }
}

