/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.conversion;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Set;
import org.mapstruct.ap.internal.conversion.ConversionUtils;
import org.mapstruct.ap.internal.conversion.SimpleConversion;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Collections;

public class JavaLocalDateToDateConversion
extends SimpleConversion {
    @Override
    protected String getToExpression(ConversionContext conversionContext) {
        return ConversionUtils.date(conversionContext) + ".from( <SOURCE>.atStartOfDay( " + ConversionUtils.zoneOffset(conversionContext) + ".UTC ).toInstant() )";
    }

    @Override
    protected Set<Type> getToConversionImportTypes(ConversionContext conversionContext) {
        return Collections.asSet(conversionContext.getTypeFactory().getType(Date.class), conversionContext.getTypeFactory().getType(ZoneOffset.class));
    }

    @Override
    protected String getFromExpression(ConversionContext conversionContext) {
        return ConversionUtils.localDateTime(conversionContext) + ".ofInstant( <SOURCE>.toInstant(), " + ConversionUtils.zoneOffset(conversionContext) + ".UTC ).toLocalDate()";
    }

    @Override
    protected Set<Type> getFromConversionImportTypes(ConversionContext conversionContext) {
        return Collections.asSet(conversionContext.getTypeFactory().getType(LocalDateTime.class), conversionContext.getTypeFactory().getType(ZoneOffset.class));
    }
}

