/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.assignment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.mapstruct.ap.internal.model.assignment.AssignmentWrapper;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Nouns;

public class StreamAdderWrapper
extends AssignmentWrapper {
    private final List<Type> thrownTypesToExclude;
    private final Type adderType;

    public StreamAdderWrapper(Assignment rhs, List<Type> thrownTypesToExclude, boolean fieldAssignment, String targetPropertyName) {
        super(rhs, fieldAssignment);
        this.thrownTypesToExclude = thrownTypesToExclude;
        String desiredName = Nouns.singularize(targetPropertyName);
        rhs.setSourceLocalVarName(rhs.createUniqueVarName(desiredName));
        this.adderType = Collections.first(this.getSourceType().determineTypeArguments(Stream.class));
    }

    @Override
    public List<Type> getThrownTypes() {
        List<Type> parentThrownTypes = super.getThrownTypes();
        ArrayList<Type> result = new ArrayList<Type>(parentThrownTypes);
        for (Type thrownTypeToExclude : this.thrownTypesToExclude) {
            for (Type parentExceptionType : parentThrownTypes) {
                if (!parentExceptionType.isAssignableTo(thrownTypeToExclude)) continue;
                result.remove(parentExceptionType);
            }
        }
        return result;
    }

    public Type getAdderType() {
        return this.adderType;
    }

    public boolean isIncludeSourceNullCheck() {
        return true;
    }

    public boolean isSetExplicitlyToNull() {
        return false;
    }

    public boolean isSetExplicitlyToDefault() {
        return false;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> imported = new HashSet<Type>(super.getImportTypes());
        imported.add(this.adderType.getTypeBound());
        return imported;
    }
}

