/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.service.jerseyclient;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.mockserver.model.Book;
import org.mockserver.service.BookService;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class BookServiceJerseyClient
implements BookService {
    @Resource
    private Environment environment;
    private Integer port;
    private Integer proxyPort;
    private String host;
    private Client client;

    @PostConstruct
    private void initialise() {
        this.port = (Integer)this.environment.getProperty("bookService.port", Integer.class);
        this.proxyPort = (Integer)this.environment.getProperty("bookService.proxyPort", Integer.class);
        this.host = this.environment.getProperty("bookService.host", "localhost");
        this.client = this.createHttpClient();
    }

    private Client createHttpClient() {
        ClientConfig clientConfig = new ClientConfig().register((Object)new JacksonFeature()).connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        if (Boolean.parseBoolean(System.getProperty("proxySet"))) {
            clientConfig.property("jersey.config.client.proxy.uri", (Object)("http://" + System.getProperty("http.proxyHost") + ":" + System.getProperty("http.proxyPort")));
        }
        return ClientBuilder.newClient((Configuration)clientConfig);
    }

    public Book[] getAllBooks() {
        try {
            return (Book[])this.client.target("http://" + this.host + ":" + this.port).path("get_books").queryParam("greeting", new Object[]{"Hi World!"}).request(new String[]{"application/json"}).get(Book[].class);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception making request to retrieve all books", e);
        }
    }

    public Book getBook(String id) {
        try {
            return (Book)this.client.target("http://localhost:" + this.port).path("get_book").queryParam("id", new Object[]{id}).request(new String[]{"application/json"}).get(Book.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception making request to retrieve a book with id [" + id + "]", e);
        }
    }
}

