/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.service.springclient;

import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.mockserver.model.Book;
import org.mockserver.service.BookService;
import org.springframework.core.env.Environment;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class BookServiceSpringRestTemplateClient
implements BookService {
    @Resource
    private Environment environment;
    private Integer port;
    private Integer proxyPort;
    private String host;
    private ObjectMapper objectMapper;
    private RestTemplate restTemplate;

    @PostConstruct
    private void initialise() {
        this.port = (Integer)this.environment.getProperty("bookService.port", Integer.class);
        this.proxyPort = (Integer)this.environment.getProperty("bookService.proxyPort", Integer.class);
        this.host = this.environment.getProperty("bookService.host", "localhost");
        this.objectMapper = this.createObjectMapper();
        this.restTemplate = this.createRestTemplate();
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_NUMBERS_FOR_ENUMS, false);
        objectMapper.configure(DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        objectMapper.configure(DeserializationConfig.Feature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        objectMapper.configure(DeserializationConfig.Feature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, true);
        objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        objectMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_EMPTY);
        return objectMapper;
    }

    private RestTemplate createRestTemplate() {
        MappingJacksonHttpMessageConverter mappingJacksonHttpMessageConverter = new MappingJacksonHttpMessageConverter();
        mappingJacksonHttpMessageConverter.setObjectMapper(this.objectMapper);
        ArrayList<MappingJacksonHttpMessageConverter> httpMessageConverters = new ArrayList<MappingJacksonHttpMessageConverter>();
        httpMessageConverters.add(mappingJacksonHttpMessageConverter);
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setMessageConverters(httpMessageConverters);
        if (Boolean.parseBoolean(System.getProperty("proxySet"))) {
            HttpHost httpHost = new HttpHost(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort")));
            DefaultProxyRoutePlanner defaultProxyRoutePlanner = new DefaultProxyRoutePlanner(httpHost);
            CloseableHttpClient httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)defaultProxyRoutePlanner).build();
            restTemplate.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient));
        }
        return restTemplate;
    }

    public Book[] getAllBooks() {
        return (Book[])this.restTemplate.getForObject("http://" + this.host + ":" + this.port + "/get_books", Book[].class, new Object[0]);
    }

    public Book getBook(String id) {
        return (Book)this.restTemplate.getForObject("http://" + this.host + ":" + this.port + "/get_book?id=" + id, Book.class, new Object[0]);
    }
}

