/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.maven;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mockserver.client.initialize.ExpectationInitializer;
import org.mockserver.configuration.IntegerStringListParser;
import org.mockserver.file.FileReader;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.maven.InstanceHolder;
import org.slf4j.event.Level;

public abstract class MockServerAbstractMojo
extends AbstractMojo {
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger();
    @VisibleForTesting
    protected static InstanceHolder instanceHolder;
    @Parameter(property="mockserver.serverPort")
    protected String serverPort = "";
    @Parameter(property="mockserver.proxyRemotePort", defaultValue="-1")
    protected Integer proxyRemotePort = -1;
    @Parameter(property="mockserver.proxyRemoteHost")
    protected String proxyRemoteHost = "";
    @Parameter(property="mockserver.timeout")
    protected Integer timeout;
    @Parameter(property="mockserver.logLevel", defaultValue="INFO")
    protected String logLevel = "INFO";
    @Parameter(property="mockserver.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="mockserver.pipeLogToConsole", defaultValue="false")
    protected boolean pipeLogToConsole;
    @Parameter(property="mockserver.initializationClass")
    protected String initializationClass;
    @Parameter(property="mockserver.initializationJson")
    protected String initializationJson;
    @Parameter(property="project.compileClasspathElements", required=true, readonly=true)
    protected List<String> compileClasspath;
    @Parameter(property="project.testClasspathElements", required=true, readonly=true)
    protected List<String> testClasspath;
    private String compileResourcePath;
    private String testResourcePath;
    @Parameter(property="pluginDescriptor.plugin.dependencies", required=true, readonly=true)
    protected List<Dependency> dependencies;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession session;
    private Integer[] serverPorts;

    Integer[] getServerPorts() {
        if (this.serverPorts == null && StringUtils.isNotEmpty((CharSequence)this.serverPort)) {
            ArrayList<Integer> ports = new ArrayList<Integer>();
            for (String port : Splitter.on((char)',').split((CharSequence)this.serverPort)) {
                ports.add(Integer.parseInt(port));
            }
            this.serverPorts = ports.toArray(new Integer[0]);
        }
        return this.serverPorts;
    }

    protected InstanceHolder getLocalMockServerInstance() {
        if (instanceHolder == null) {
            instanceHolder = new InstanceHolder();
        }
        return instanceHolder;
    }

    protected ExpectationInitializer createInitializerClass() {
        try {
            Constructor<?> initializerClassConstructor;
            Object pluginExpectationInitializer;
            Class<?> loadedClass;
            ClassLoader contextClassLoader = this.setupClasspath();
            if (contextClassLoader == null) {
                contextClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            if (StringUtils.isNotBlank((CharSequence)this.initializationClass) && contextClassLoader != null && (loadedClass = contextClassLoader.loadClass(this.initializationClass)) != null && (pluginExpectationInitializer = (initializerClassConstructor = loadedClass.getDeclaredConstructor(new Class[0])).newInstance(new Object[0])) instanceof ExpectationInitializer) {
                return (ExpectationInitializer)pluginExpectationInitializer;
            }
        }
        catch (Throwable throwable) {
            MOCK_SERVER_LOGGER.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception loading class expectation initializer").setThrowable(throwable));
        }
        return null;
    }

    protected String createInitializerJson() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.initializationJson) && this.compileResourcePath != null) {
                try {
                    return FileReader.readFileFromClassPathOrPath((String)(this.compileResourcePath + "/" + this.initializationJson));
                }
                catch (RuntimeException exception) {
                    return FileReader.readFileFromClassPathOrPath((String)(this.testResourcePath + "/" + this.initializationJson));
                }
            }
        }
        catch (Throwable throwable) {
            MOCK_SERVER_LOGGER.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception loading json expectation initializer").setThrowable(throwable));
        }
        return "";
    }

    private ClassLoader setupClasspath() throws MalformedURLException {
        if (this.compileClasspath != null && this.testClasspath != null) {
            int i;
            URL[] urls = new URL[this.compileClasspath.size() + this.testClasspath.size()];
            for (i = 0; i < this.compileClasspath.size(); ++i) {
                urls[i] = new File(this.compileClasspath.get(i)).toURI().toURL();
            }
            for (i = this.compileClasspath.size(); i < this.compileClasspath.size() + this.testClasspath.size(); ++i) {
                String testClasspathEntry = this.testClasspath.get(i - this.compileClasspath.size());
                urls[i] = new File(testClasspathEntry).toURI().toURL();
                if (testClasspathEntry.matches(".*[\\\\|/]target[\\\\|/]classes")) {
                    this.compileResourcePath = testClasspathEntry;
                    continue;
                }
                if (!testClasspathEntry.matches(".*[\\\\|/]target[\\\\|/]test-classes")) continue;
                this.testResourcePath = testClasspathEntry;
            }
            URLClassLoader contextClassLoader = URLClassLoader.newInstance(urls, Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            return contextClassLoader;
        }
        return null;
    }

    public static List<Integer> mockServerPort() {
        String mockServerPort = System.getProperty("mockserver.mockServerPort");
        try {
            return MockServerAbstractMojo.toList(mockServerPort);
        }
        catch (NumberFormatException nfe) {
            MOCK_SERVER_LOGGER.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("NumberFormatException converting mockserver.mockServerPort with value [" + mockServerPort + "]").setThrowable((Throwable)nfe));
            return Collections.emptyList();
        }
    }

    public static void mockServerPort(Integer ... port) {
        System.setProperty("mockserver.mockServerPort", new IntegerStringListParser().toString(port));
    }

    private static List<Integer> toList(String integers) {
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        for (String integer : Splitter.on((String)",").split((CharSequence)integers)) {
            try {
                integerList.add(Integer.parseInt(integer.trim()));
            }
            catch (NumberFormatException throwable) {
                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("NumberFormatException converting " + integer + " to integer").setThrowable((Throwable)throwable));
            }
        }
        return integerList;
    }
}

