/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.maven;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.mockserver.client.initialize.ExpectationInitializer;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.maven.MockServerAbstractMojo;

@Mojo(name="run", requiresProject=false)
public class MockServerRunAndWaitMojo
extends MockServerAbstractMojo {
    private CompletableFuture<Object> settableFuture = new CompletableFuture();

    public void execute() {
        if (StringUtils.isNotBlank((CharSequence)this.logLevel)) {
            ConfigurationProperties.logLevel((String)this.logLevel);
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
        } else {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("mockserver:run about to start MockServer on: " + (this.getServerPorts() != null ? " serverPort " + Arrays.toString((Object[])this.getServerPorts()) : "")));
            }
            try {
                ExpectationInitializer initializerClass = this.createInitializerClass();
                String initializerJson = this.createInitializerJson();
                if (this.timeout != null && this.timeout > 0) {
                    this.getLocalMockServerInstance().start(this.getServerPorts(), this.proxyRemotePort, this.proxyRemoteHost, this.logLevel, initializerClass, initializerJson);
                    try {
                        this.settableFuture.get(this.timeout.intValue(), TimeUnit.SECONDS);
                    }
                    catch (TimeoutException timeoutException) {}
                } else {
                    this.getLocalMockServerInstance().start(this.getServerPorts(), this.proxyRemotePort, this.proxyRemoteHost, this.logLevel, initializerClass, initializerJson);
                    this.settableFuture.get();
                }
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Exception while running MockServer", (Throwable)e);
            }
        }
    }
}

