/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson.internal.io;

import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonBinary;
import org.mongodb.kbson.BsonDBPointer;
import org.mongodb.kbson.BsonDecimal128;
import org.mongodb.kbson.BsonDocument;
import org.mongodb.kbson.BsonInvalidOperationException;
import org.mongodb.kbson.BsonObjectId;
import org.mongodb.kbson.BsonRegularExpression;
import org.mongodb.kbson.BsonSerializationException;
import org.mongodb.kbson.BsonType;
import org.mongodb.kbson.BsonValue;
import org.mongodb.kbson.internal.io.AbstractBsonReader;
import org.mongodb.kbson.internal.io.BsonContextType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0018H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0012H\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u001eH\u0014J\b\u0010 \u001a\u00020\u0018H\u0014J\b\u0010!\u001a\u00020\u0018H\u0014J\b\u0010\"\u001a\u00020\u0018H\u0014J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020\u0018H\u0014J\b\u0010(\u001a\u00020\u0018H\u0014J\b\u0010)\u001a\u00020\u001eH\u0014J\b\u0010*\u001a\u00020\u001eH\u0014J\b\u0010+\u001a\u00020\u0012H\u0014J\b\u0010,\u001a\u00020\u0018H\u0014J\b\u0010-\u001a\u00020\u0018H\u0014J\b\u0010.\u001a\u00020\u0018H\u0014J\b\u0010/\u001a\u000200H\u0016R&\u0010\u0005\u001a\u00060\u0006R\u00020\u00002\n\u0010\u0005\u001a\u00060\u0006R\u00020\u0000@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/mongodb/kbson/internal/io/BsonDocumentReader;", "Lorg/mongodb/kbson/internal/io/AbstractBsonReader;", "document", "Lorg/mongodb/kbson/BsonDocument;", "(Lorg/mongodb/kbson/BsonDocument;)V", "context", "Lorg/mongodb/kbson/internal/io/BsonDocumentReader$BsonDocumentReaderContext;", "setContext", "(Lorg/mongodb/kbson/internal/io/BsonDocumentReader$BsonDocumentReaderContext;)V", "currentValue", "Lorg/mongodb/kbson/BsonValue;", "doReadBinaryData", "Lorg/mongodb/kbson/BsonBinary;", "doReadBoolean", "", "doReadDBPointer", "Lorg/mongodb/kbson/BsonDBPointer;", "doReadDateTime", "", "doReadDecimal128", "Lorg/mongodb/kbson/BsonDecimal128;", "doReadDouble", "", "doReadEndArray", "", "doReadEndDocument", "doReadInt32", "", "doReadInt64", "doReadJavaScript", "", "doReadJavaScriptWithScope", "doReadMaxKey", "doReadMinKey", "doReadNull", "doReadObjectId", "Lorg/mongodb/kbson/BsonObjectId;", "doReadRegularExpression", "Lorg/mongodb/kbson/BsonRegularExpression;", "doReadStartArray", "doReadStartDocument", "doReadString", "doReadSymbol", "doReadTimestamp", "doReadUndefined", "doSkipName", "doSkipValue", "readBsonType", "Lorg/mongodb/kbson/BsonType;", "BsonDocumentReaderContext", "kbson_debug"})
public final class BsonDocumentReader
extends AbstractBsonReader {
    @NotNull
    private BsonDocumentReaderContext context;
    @NotNull
    private BsonValue currentValue;

    public BsonDocumentReader(@NotNull BsonDocument document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.context = new BsonDocumentReaderContext(null, BsonContextType.TOP_LEVEL, document);
        this.currentValue = document;
    }

    private final void setContext(BsonDocumentReaderContext context) {
        this.set_context(context);
        this.context = context;
    }

    @Override
    @NotNull
    protected BsonBinary doReadBinaryData() {
        return this.currentValue.asBinary();
    }

    @Override
    protected boolean doReadBoolean() {
        return this.currentValue.asBoolean().getValue();
    }

    @Override
    protected long doReadDateTime() {
        return this.currentValue.asDateTime().getValue();
    }

    @Override
    protected double doReadDouble() {
        return this.currentValue.asDouble().getValue();
    }

    @Override
    protected void doReadEndArray() {
        this.setContext(this.context.popContext());
    }

    @Override
    protected void doReadEndDocument() {
        AbstractBsonReader.State state;
        this.setContext(this.context.popContext());
        switch (WhenMappings.$EnumSwitchMapping$0[this.context.getContextType().ordinal()]) {
            case 1: 
            case 2: {
                state = AbstractBsonReader.State.TYPE;
                break;
            }
            case 3: {
                state = AbstractBsonReader.State.DONE;
                break;
            }
            default: {
                throw new BsonSerializationException("Unexpected ContextType.", null, 2, null);
            }
        }
        this.setState(state);
    }

    @Override
    protected int doReadInt32() {
        return this.currentValue.asInt32().getValue();
    }

    @Override
    protected long doReadInt64() {
        return this.currentValue.asInt64().getValue();
    }

    @Override
    @NotNull
    protected BsonDecimal128 doReadDecimal128() {
        return this.currentValue.asDecimal128();
    }

    @Override
    @NotNull
    protected String doReadJavaScript() {
        return this.currentValue.asJavaScript().getCode();
    }

    @Override
    @NotNull
    protected String doReadJavaScriptWithScope() {
        return this.currentValue.asJavaScriptWithScope().getCode();
    }

    @Override
    protected void doReadMaxKey() {
    }

    @Override
    protected void doReadMinKey() {
    }

    @Override
    protected void doReadNull() {
    }

    @Override
    @NotNull
    protected BsonObjectId doReadObjectId() {
        return this.currentValue.asObjectId();
    }

    @Override
    @NotNull
    protected BsonRegularExpression doReadRegularExpression() {
        return this.currentValue.asRegularExpression();
    }

    @Override
    @NotNull
    protected BsonDBPointer doReadDBPointer() {
        return this.currentValue.asDBPointer();
    }

    @Override
    protected void doReadStartArray() {
        this.setContext(new BsonDocumentReaderContext(this.context, BsonContextType.ARRAY, this.currentValue.asArray()));
    }

    @Override
    protected void doReadStartDocument() {
        BsonDocument document = this.currentValue.getBsonType() == BsonType.JAVASCRIPT_WITH_SCOPE ? this.currentValue.asJavaScriptWithScope().getScope() : this.currentValue.asDocument();
        this.setContext(new BsonDocumentReaderContext(this.context, BsonContextType.DOCUMENT, document));
    }

    @Override
    @NotNull
    protected String doReadString() {
        return this.currentValue.asString().getValue();
    }

    @Override
    @NotNull
    protected String doReadSymbol() {
        return this.currentValue.asSymbol().getValue();
    }

    @Override
    protected long doReadTimestamp() {
        return this.currentValue.asTimestamp().getValue();
    }

    @Override
    protected void doReadUndefined() {
    }

    @Override
    protected void doSkipName() {
    }

    @Override
    protected void doSkipValue() {
    }

    @Override
    @NotNull
    public BsonType readBsonType() {
        if (this.getState() == AbstractBsonReader.State.INITIAL || this.getState() == AbstractBsonReader.State.DONE || this.getState() == AbstractBsonReader.State.SCOPE_DOCUMENT) {
            this.setCurrentBsonType(BsonType.DOCUMENT);
            this.setState(AbstractBsonReader.State.VALUE);
            BsonType bsonType = this.getCurrentBsonType();
            Intrinsics.checkNotNull((Object)((Object)bsonType));
            return bsonType;
        }
        boolean value$iv = this.getState() == AbstractBsonReader.State.TYPE;
        boolean $i$f$validateOperation = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "readBsonType can only be called when State is " + (Object)((Object)AbstractBsonReader.State.TYPE) + ", not when State is " + (Object)((Object)this.getState()) + '.';
            throw new BsonInvalidOperationException(message$iv.toString(), null, 2, null);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.context.getContextType().ordinal()]) {
            case 1: {
                if (this.context.getArrayIterator().hasNext()) {
                    this.currentValue = this.context.getArrayIterator().next();
                    this.setState(AbstractBsonReader.State.VALUE);
                    break;
                }
                this.setState(AbstractBsonReader.State.END_OF_ARRAY);
                return BsonType.END_OF_DOCUMENT;
            }
            case 2: {
                if (this.context.getDocumentIterator().hasNext()) {
                    Map.Entry<String, BsonValue> currentElement = this.context.getDocumentIterator().next();
                    this.setCurrentName(currentElement.getKey());
                    this.currentValue = currentElement.getValue();
                    this.setState(AbstractBsonReader.State.NAME);
                    break;
                }
                this.setState(AbstractBsonReader.State.END_OF_DOCUMENT);
                return BsonType.END_OF_DOCUMENT;
            }
            default: {
                throw new BsonSerializationException("Invalid ContextType.", null, 2, null);
            }
        }
        this.setCurrentBsonType(this.currentValue.getBsonType());
        return this.currentValue.getBsonType();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0007\n\u0002\u0010)\n\u0002\u0010'\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B#\u0012\f\u0010\u0003\u001a\b\u0018\u00010\u0000R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\u0018\u001a\u00060\u0000R\u00020\u0004R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R-\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\b0\u00140\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0016\u0010\rR\u0014\u0010\u0003\u001a\b\u0018\u00010\u0000R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/mongodb/kbson/internal/io/BsonDocumentReader$BsonDocumentReaderContext;", "Lorg/mongodb/kbson/internal/io/AbstractBsonReader$Context;", "Lorg/mongodb/kbson/internal/io/AbstractBsonReader;", "parentContext", "Lorg/mongodb/kbson/internal/io/BsonDocumentReader;", "contextType", "Lorg/mongodb/kbson/internal/io/BsonContextType;", "bsonValue", "Lorg/mongodb/kbson/BsonValue;", "(Lorg/mongodb/kbson/internal/io/BsonDocumentReader;Lorg/mongodb/kbson/internal/io/BsonDocumentReader$BsonDocumentReaderContext;Lorg/mongodb/kbson/internal/io/BsonContextType;Lorg/mongodb/kbson/BsonValue;)V", "arrayIterator", "", "getArrayIterator", "()Ljava/util/Iterator;", "arrayIterator$delegate", "Lkotlin/Lazy;", "getBsonValue", "()Lorg/mongodb/kbson/BsonValue;", "documentIterator", "", "", "", "getDocumentIterator", "documentIterator$delegate", "popContext", "kbson_debug"})
    private final class BsonDocumentReaderContext
    extends AbstractBsonReader.Context {
        @Nullable
        private final BsonDocumentReaderContext parentContext;
        @NotNull
        private final BsonValue bsonValue;
        @NotNull
        private final Lazy arrayIterator$delegate;
        @NotNull
        private final Lazy documentIterator$delegate;

        public BsonDocumentReaderContext(@NotNull BsonDocumentReaderContext parentContext, @NotNull BsonContextType contextType, BsonValue bsonValue) {
            Intrinsics.checkNotNullParameter((Object)BsonDocumentReader.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)contextType), (String)"contextType");
            Intrinsics.checkNotNullParameter((Object)bsonValue, (String)"bsonValue");
            super(contextType);
            this.parentContext = parentContext;
            this.bsonValue = bsonValue;
            this.arrayIterator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Iterator<? extends BsonValue>>(this){
                final /* synthetic */ BsonDocumentReaderContext this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Iterator<BsonValue> invoke() {
                    return this.this$0.getBsonValue().asArray().getValues().iterator();
                }
            }));
            this.documentIterator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Iterator<? extends Map.Entry<String, BsonValue>>>(this){
                final /* synthetic */ BsonDocumentReaderContext this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Iterator<Map.Entry<String, BsonValue>> invoke() {
                    return this.this$0.getBsonValue().asDocument().entrySet().iterator();
                }
            }));
        }

        @NotNull
        public final BsonValue getBsonValue() {
            return this.bsonValue;
        }

        @NotNull
        public final Iterator<BsonValue> getArrayIterator() {
            Lazy lazy = this.arrayIterator$delegate;
            return (Iterator)lazy.getValue();
        }

        @NotNull
        public final Iterator<Map.Entry<String, BsonValue>> getDocumentIterator() {
            Lazy lazy = this.documentIterator$delegate;
            return (Iterator)lazy.getValue();
        }

        @NotNull
        public final BsonDocumentReaderContext popContext() {
            boolean value$iv = this.parentContext != null;
            boolean $i$f$validateSerialization = false;
            if (!value$iv) {
                boolean bl = false;
                String message$iv = "Missing parent context.";
                throw new BsonSerializationException(message$iv.toString(), null, 2, null);
            }
            return this.parentContext;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BsonContextType.values().length];
            nArray[BsonContextType.ARRAY.ordinal()] = 1;
            nArray[BsonContextType.DOCUMENT.ordinal()] = 2;
            nArray[BsonContextType.TOP_LEVEL.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

