/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson.internal.io;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mongodb.kbson.BsonArray;
import org.mongodb.kbson.BsonBinary;
import org.mongodb.kbson.BsonBoolean;
import org.mongodb.kbson.BsonDBPointer;
import org.mongodb.kbson.BsonDateTime;
import org.mongodb.kbson.BsonDecimal128;
import org.mongodb.kbson.BsonDocument;
import org.mongodb.kbson.BsonDouble;
import org.mongodb.kbson.BsonInt32;
import org.mongodb.kbson.BsonInt64;
import org.mongodb.kbson.BsonInvalidOperationException;
import org.mongodb.kbson.BsonJavaScript;
import org.mongodb.kbson.BsonJavaScriptWithScope;
import org.mongodb.kbson.BsonMaxKey;
import org.mongodb.kbson.BsonMinKey;
import org.mongodb.kbson.BsonNull;
import org.mongodb.kbson.BsonObjectId;
import org.mongodb.kbson.BsonRegularExpression;
import org.mongodb.kbson.BsonSerializationException;
import org.mongodb.kbson.BsonString;
import org.mongodb.kbson.BsonSymbol;
import org.mongodb.kbson.BsonTimestamp;
import org.mongodb.kbson.BsonUndefined;
import org.mongodb.kbson.BsonValue;
import org.mongodb.kbson.internal.io.AbstractBsonWriter;
import org.mongodb.kbson.internal.io.BsonContextType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u00014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\fH\u0014J\b\u0010\u001a\u001a\u00020\fH\u0014J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0014H\u0014J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\r\u001a\u00020!H\u0014J\b\u0010\"\u001a\u00020\fH\u0014J\b\u0010#\u001a\u00020\fH\u0014J\u0010\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020!H\u0014J\b\u0010&\u001a\u00020\fH\u0014J\u0010\u0010'\u001a\u00020\f2\u0006\u0010\r\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020\f2\u0006\u0010\r\u001a\u00020*H\u0014J\b\u0010+\u001a\u00020\fH\u0014J\b\u0010,\u001a\u00020\fH\u0014J\u0010\u0010-\u001a\u00020\f2\u0006\u0010\r\u001a\u00020!H\u0014J\u0010\u0010.\u001a\u00020\f2\u0006\u0010\r\u001a\u00020!H\u0014J\u0010\u0010/\u001a\u00020\f2\u0006\u0010\r\u001a\u000200H\u0014J\b\u00101\u001a\u00020\fH\u0014J\u0010\u00102\u001a\u00020\f2\u0006\u0010\r\u001a\u000203H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R&\u0010\u0007\u001a\u00060\bR\u00020\u00002\n\u0010\u0007\u001a\u00060\bR\u00020\u0000@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\t\u0010\n\u00a8\u00065"}, d2={"Lorg/mongodb/kbson/internal/io/BsonDocumentWriter;", "Lorg/mongodb/kbson/internal/io/AbstractBsonWriter;", "()V", "bsonDocument", "Lorg/mongodb/kbson/BsonDocument;", "getBsonDocument", "()Lorg/mongodb/kbson/BsonDocument;", "context", "Lorg/mongodb/kbson/internal/io/BsonDocumentWriter$BsonDocumentWriterContext;", "setContext", "(Lorg/mongodb/kbson/internal/io/BsonDocumentWriter$BsonDocumentWriterContext;)V", "doWriteBinaryData", "", "value", "Lorg/mongodb/kbson/BsonBinary;", "doWriteBoolean", "", "doWriteDBPointer", "Lorg/mongodb/kbson/BsonDBPointer;", "doWriteDateTime", "", "doWriteDecimal128", "Lorg/mongodb/kbson/BsonDecimal128;", "doWriteDouble", "", "doWriteEndArray", "doWriteEndDocument", "doWriteInt32", "", "doWriteInt64", "doWriteJavaScript", "Lorg/mongodb/kbson/BsonJavaScript;", "doWriteJavaScriptWithScope", "", "doWriteMaxKey", "doWriteMinKey", "doWriteName", "name", "doWriteNull", "doWriteObjectId", "Lorg/mongodb/kbson/BsonObjectId;", "doWriteRegularExpression", "Lorg/mongodb/kbson/BsonRegularExpression;", "doWriteStartArray", "doWriteStartDocument", "doWriteString", "doWriteSymbol", "doWriteTimestamp", "Lorg/mongodb/kbson/BsonTimestamp;", "doWriteUndefined", "write", "Lorg/mongodb/kbson/BsonValue;", "BsonDocumentWriterContext", "kbson_debug"})
public final class BsonDocumentWriter
extends AbstractBsonWriter {
    @NotNull
    private final BsonDocument bsonDocument = new BsonDocument(null, 1, null);
    @NotNull
    private BsonDocumentWriterContext context = new BsonDocumentWriterContext(null, BsonContextType.TOP_LEVEL, this.bsonDocument, null, 8, null);

    public BsonDocumentWriter() {
        super(0, 1, null);
    }

    @NotNull
    public final BsonDocument getBsonDocument() {
        return this.bsonDocument;
    }

    private final void setContext(BsonDocumentWriterContext context) {
        this.set_context(context);
        this.context = context;
    }

    @Override
    protected void doWriteStartDocument() {
        BsonDocumentWriterContext bsonDocumentWriterContext;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getState().ordinal()]) {
            case 1: {
                bsonDocumentWriterContext = new BsonDocumentWriterContext(this.context, BsonContextType.DOCUMENT, this.bsonDocument, null, 8, null);
                break;
            }
            case 2: {
                bsonDocumentWriterContext = new BsonDocumentWriterContext(this.context, BsonContextType.DOCUMENT, new BsonDocument(null, 1, null), null, 8, null);
                break;
            }
            case 3: {
                bsonDocumentWriterContext = new BsonDocumentWriterContext(this.context, BsonContextType.SCOPE_DOCUMENT, new BsonDocument(null, 1, null), null, 8, null);
                break;
            }
            default: {
                throw new BsonInvalidOperationException(Intrinsics.stringPlus((String)"Unexpected state ", (Object)((Object)this.getState())), null, 2, null);
            }
        }
        this.setContext(bsonDocumentWriterContext);
    }

    @Override
    protected void doWriteEndDocument() {
        BsonValue value = this.context.getContainer();
        BsonDocumentWriterContext bsonDocumentWriterContext = this.context.getParentContext();
        Intrinsics.checkNotNull((Object)bsonDocumentWriterContext);
        this.setContext(bsonDocumentWriterContext);
        if (this.context.getContextType() == BsonContextType.JAVASCRIPT_WITH_SCOPE) {
            BsonString code = (BsonString)this.context.getContainer();
            BsonDocument scope = (BsonDocument)value;
            BsonDocumentWriterContext bsonDocumentWriterContext2 = this.context.getParentContext();
            Intrinsics.checkNotNull((Object)bsonDocumentWriterContext2);
            this.setContext(bsonDocumentWriterContext2);
            this.write(new BsonJavaScriptWithScope(code.getValue(), scope));
        } else if (this.context.getContextType() != BsonContextType.TOP_LEVEL) {
            this.write(value);
        }
    }

    @Override
    protected void doWriteStartArray() {
        this.setContext(new BsonDocumentWriterContext(this.context, BsonContextType.ARRAY, new BsonArray(null, 1, null), null, 8, null));
    }

    @Override
    protected void doWriteEndArray() {
        BsonValue value = this.context.getContainer();
        BsonDocumentWriterContext bsonDocumentWriterContext = this.context.getParentContext();
        Intrinsics.checkNotNull((Object)bsonDocumentWriterContext);
        this.setContext(bsonDocumentWriterContext);
        this.write(value);
    }

    @Override
    protected void doWriteBinaryData(@NotNull BsonBinary value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.write(value);
    }

    @Override
    protected void doWriteBoolean(boolean value) {
        this.write(new BsonBoolean(value));
    }

    @Override
    protected void doWriteDateTime(long value) {
        this.write(new BsonDateTime(value));
    }

    @Override
    protected void doWriteDBPointer(@NotNull BsonDBPointer value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.write(value);
    }

    @Override
    protected void doWriteDouble(double value) {
        this.write(new BsonDouble(value));
    }

    @Override
    protected void doWriteInt32(int value) {
        this.write(new BsonInt32(value));
    }

    @Override
    protected void doWriteInt64(long value) {
        this.write(new BsonInt64(value));
    }

    @Override
    protected void doWriteDecimal128(@NotNull BsonDecimal128 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.write(value);
    }

    @Override
    protected void doWriteJavaScript(@NotNull BsonJavaScript value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.write(value);
    }

    @Override
    protected void doWriteJavaScriptWithScope(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setContext(new BsonDocumentWriterContext(this.context, BsonContextType.JAVASCRIPT_WITH_SCOPE, new BsonString(value), this.context.getCurrentName()));
    }

    @Override
    protected void doWriteMaxKey() {
        this.write(BsonMaxKey.INSTANCE);
    }

    @Override
    protected void doWriteMinKey() {
        this.write(BsonMinKey.INSTANCE);
    }

    @Override
    protected void doWriteNull() {
        this.write(BsonNull.INSTANCE);
    }

    @Override
    protected void doWriteObjectId(@NotNull BsonObjectId value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.write(value);
    }

    @Override
    protected void doWriteRegularExpression(@NotNull BsonRegularExpression value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.write(value);
    }

    @Override
    protected void doWriteString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.write(new BsonString(value));
    }

    @Override
    protected void doWriteSymbol(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.write(new BsonSymbol(value));
    }

    @Override
    protected void doWriteTimestamp(@NotNull BsonTimestamp value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.write(value);
    }

    @Override
    protected void doWriteUndefined() {
        this.write(BsonUndefined.INSTANCE);
    }

    @Override
    protected void doWriteName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.setContext(new BsonDocumentWriterContext(this.context.getParentContext(), this.context.getContextType(), this.context.getContainer(), name));
    }

    private final void write(BsonValue value) {
        this.context.add(value);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B/\u0012\f\u0010\u0003\u001a\b\u0018\u00010\u0000R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0003\u001a\b\u0018\u00010\u0000R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lorg/mongodb/kbson/internal/io/BsonDocumentWriter$BsonDocumentWriterContext;", "Lorg/mongodb/kbson/internal/io/AbstractBsonWriter$Context;", "Lorg/mongodb/kbson/internal/io/AbstractBsonWriter;", "parentContext", "Lorg/mongodb/kbson/internal/io/BsonDocumentWriter;", "contextType", "Lorg/mongodb/kbson/internal/io/BsonContextType;", "container", "Lorg/mongodb/kbson/BsonValue;", "currentName", "", "(Lorg/mongodb/kbson/internal/io/BsonDocumentWriter;Lorg/mongodb/kbson/internal/io/BsonDocumentWriter$BsonDocumentWriterContext;Lorg/mongodb/kbson/internal/io/BsonContextType;Lorg/mongodb/kbson/BsonValue;Ljava/lang/String;)V", "getContainer", "()Lorg/mongodb/kbson/BsonValue;", "getCurrentName", "()Ljava/lang/String;", "getParentContext", "()Lorg/mongodb/kbson/internal/io/BsonDocumentWriter$BsonDocumentWriterContext;", "add", "", "value", "kbson_debug"})
    private final class BsonDocumentWriterContext
    extends AbstractBsonWriter.Context {
        @Nullable
        private final BsonDocumentWriterContext parentContext;
        @NotNull
        private final BsonValue container;
        @Nullable
        private final String currentName;

        public BsonDocumentWriterContext(@NotNull BsonDocumentWriterContext parentContext, @NotNull BsonContextType contextType, @Nullable BsonValue container, String currentName) {
            Intrinsics.checkNotNullParameter((Object)BsonDocumentWriter.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)contextType), (String)"contextType");
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            super(contextType, currentName);
            this.parentContext = parentContext;
            this.container = container;
            this.currentName = currentName;
        }

        public /* synthetic */ BsonDocumentWriterContext(BsonDocumentWriterContext bsonDocumentWriterContext, BsonContextType bsonContextType, BsonValue bsonValue, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string = null;
            }
            this(bsonDocumentWriterContext, bsonContextType, bsonValue, string);
        }

        @Nullable
        public final BsonDocumentWriterContext getParentContext() {
            return this.parentContext;
        }

        @NotNull
        public final BsonValue getContainer() {
            return this.container;
        }

        @Nullable
        public final String getCurrentName() {
            return this.currentName;
        }

        public final void add(@NotNull BsonValue value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (!(this.container.isDocument() || this.container.isArray())) {
                boolean $i$a$-require-BsonDocumentWriter$BsonDocumentWriterContext$add$22 = false;
                String $i$a$-require-BsonDocumentWriter$BsonDocumentWriterContext$add$22 = "Cannot add " + value + " to " + this.getContainer();
                throw new IllegalArgumentException($i$a$-require-BsonDocumentWriter$BsonDocumentWriterContext$add$22.toString());
            }
            if (this.container.isDocument()) {
                boolean value$iv = this.currentName != null;
                boolean $i$f$validateSerialization = false;
                if (!value$iv) {
                    boolean bl = false;
                    String message$iv = "Missing fields current name.";
                    throw new BsonSerializationException(message$iv.toString(), null, 2, null);
                }
                Map map = this.container.asDocument();
                String string = this.currentName;
                map.put(string, value);
            } else {
                this.container.asArray().add(value);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AbstractBsonWriter.State.values().length];
            nArray[AbstractBsonWriter.State.INITIAL.ordinal()] = 1;
            nArray[AbstractBsonWriter.State.VALUE.ordinal()] = 2;
            nArray[AbstractBsonWriter.State.SCOPE_DOCUMENT.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

