/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson.internal.io;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.mongodb.kbson.BsonObjectId;
import org.mongodb.kbson.BsonSerializationException;
import org.mongodb.kbson.internal.io.BsonOutput;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0006\u0010\u0011\u001a\u00020\u0006J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J \u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u001aH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0004R\u0014\u0010\u000b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\t\u00a8\u0006$"}, d2={"Lorg/mongodb/kbson/internal/io/ByteArrayBsonOutput;", "Lorg/mongodb/kbson/internal/io/BsonOutput;", "initialSize", "", "(I)V", "array", "", "position", "getPosition", "()I", "setPosition", "size", "getSize", "close", "", "ensureCapacity", "elementsToAppend", "toByteArray", "writeByte", "value", "", "writeBytes", "bytes", "offset", "length", "writeCString", "", "writeDouble", "", "writeInt32", "writeInt64", "", "writeObjectId", "Lorg/mongodb/kbson/BsonObjectId;", "writeString", "Companion", "kbson_debug"})
public final class ByteArrayBsonOutput
implements BsonOutput {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private int position;
    @NotNull
    private byte[] array;
    @Deprecated
    private static final int DEFAULT_BYTE_ARRAY_SIZE = 1024;
    @Deprecated
    private static final byte NULL_BYTE = 0;

    public ByteArrayBsonOutput(int initialSize) {
        this.array = new byte[initialSize];
    }

    public /* synthetic */ ByteArrayBsonOutput(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1024;
        }
        this(n);
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int n) {
        this.position = n;
    }

    @Override
    public int getSize() {
        return this.getPosition();
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byteArray = new byte[this.getPosition()];
        ArraysKt.copyInto((byte[])this.array, (byte[])byteArray, (int)0, (int)0, (int)this.getPosition());
        return byteArray;
    }

    @Override
    public void writeBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.writeBytes(bytes, 0, bytes.length);
    }

    @Override
    public void writeBytes(@NotNull byte[] bytes, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.ensureCapacity(length);
        ArraysKt.copyInto((byte[])bytes, (byte[])this.array, (int)this.getPosition(), (int)offset, (int)length);
        this.setPosition(this.getPosition() + length);
    }

    @Override
    public void writeByte(byte value) {
        this.ensureCapacity(1);
        int n = this.getPosition();
        this.setPosition(n + 1);
        this.array[n] = value;
    }

    @Override
    public void writeCString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        byte[] byteArray = StringsKt.encodeToByteArray((String)value);
        boolean value$iv = !ArraysKt.contains((byte[])byteArray, (byte)0);
        boolean $i$f$validateSerialization = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "BSON cstring '" + value + "' is not valid because it contains a null character at index " + ArraysKt.indexOf((byte[])byteArray, (byte)0);
            throw new BsonSerializationException(message$iv.toString(), null, 2, null);
        }
        this.writeBytes(byteArray);
        this.writeByte((byte)0);
    }

    @Override
    public void writeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        byte[] byteArray = ArraysKt.plus((byte[])StringsKt.encodeToByteArray((String)value), (byte)0);
        this.writeInt32(byteArray.length);
        this.writeBytes(byteArray);
    }

    @Override
    public void writeDouble(double value) {
        this.writeInt64(Double.doubleToRawLongBits(value));
    }

    @Override
    public void writeInt32(int value) {
        int n = 0;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)24, (int)8);
        if (n <= n2) {
            int i;
            do {
                i = n;
                n += 8;
                this.writeByte((byte)(value >> i));
            } while (i != n2);
        }
    }

    @Override
    public void writeInt32(int position, int value) {
        int localPosition = this.getPosition();
        this.setPosition(position);
        this.writeInt32(value);
        this.setPosition(localPosition);
    }

    @Override
    public void writeInt64(long value) {
        int n = 0;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)56, (int)8);
        if (n <= n2) {
            int i;
            do {
                i = n;
                n += 8;
                this.writeByte((byte)(0xFFL & value >> i));
            } while (i != n2);
        }
    }

    @Override
    public void writeObjectId(@NotNull BsonObjectId value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writeBytes(value.toByteArray());
    }

    @Override
    public void close() {
    }

    private final void ensureCapacity(int elementsToAppend) {
        if (this.getPosition() + elementsToAppend <= this.array.length) {
            return;
        }
        byte[] newArray = new byte[Integer.highestOneBit(this.getPosition() + elementsToAppend) << 1];
        ArraysKt.copyInto$default((byte[])this.array, (byte[])newArray, (int)0, (int)0, (int)0, (int)14, null);
        this.array = newArray;
    }

    public ByteArrayBsonOutput() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/mongodb/kbson/internal/io/ByteArrayBsonOutput$Companion;", "", "()V", "DEFAULT_BYTE_ARRAY_SIZE", "", "NULL_BYTE", "", "kbson_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

