/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.kbson.serialization;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.mongodb.kbson.BsonArray;
import org.mongodb.kbson.BsonDocument;
import org.mongodb.kbson.BsonDouble;
import org.mongodb.kbson.BsonInt32;
import org.mongodb.kbson.BsonInt64;
import org.mongodb.kbson.BsonInvalidOperationException;
import org.mongodb.kbson.BsonNull;
import org.mongodb.kbson.BsonNumber;
import org.mongodb.kbson.BsonString;
import org.mongodb.kbson.BsonType;
import org.mongodb.kbson.BsonValue;
import org.mongodb.kbson.serialization.BsonDoubleSerializer;
import org.mongodb.kbson.serialization.BsonInt32Serializer;
import org.mongodb.kbson.serialization.BsonInt64Serializer;
import org.mongodb.kbson.serialization.BsonNullSerializer;
import org.mongodb.kbson.serialization.BsonSerializer;
import org.mongodb.kbson.serialization.BsonValueSerializer;
import org.mongodb.kbson.serialization.ClassBsonDecoder;
import org.mongodb.kbson.serialization.ListBsonBinaryDecoder;
import org.mongodb.kbson.serialization.ListBsonDecoder;
import org.mongodb.kbson.serialization.MapBsonDecoder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0018H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J!\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#H\u0016\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\"\u0010)\u001a\u0002H!\"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#H\u0082\b\u00a2\u0006\u0002\u0010$J\u001c\u0010*\u001a\u0002H!\"\u0004\b\u0000\u0010!2\u0006\u0010\"\u001a\u00020+H\u0082\b\u00a2\u0006\u0002\u0010,J!\u0010-\u001a\u0002H!\"\u0004\b\u0000\u0010!2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H!0/H\u0016\u00a2\u0006\u0002\u00100R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/mongodb/kbson/serialization/BsonDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "value", "Lorg/mongodb/kbson/BsonValue;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "ignoreUnknownKeys", "", "(Lorg/mongodb/kbson/BsonValue;Lkotlinx/serialization/modules/SerializersModule;Z)V", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "currentValue", "decodeBoolean", "decodeByte", "", "decodeChar", "", "decodeDouble", "", "decodeElementIndex", "", "decodeEnum", "enumDescriptor", "decodeFloat", "", "decodeInt", "decodeLong", "", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "decodeShort", "", "decodeString", "", "fastPathBsonNull", "fastPathBsonValue", "Lorg/mongodb/kbson/serialization/BsonSerializer;", "(Lorg/mongodb/kbson/serialization/BsonSerializer;)Ljava/lang/Object;", "rethrowAsSerializationException", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kbson_debug"})
public class BsonDecoder
extends AbstractDecoder {
    @NotNull
    private final BsonValue value;
    @NotNull
    private final SerializersModule serializersModule;
    private final boolean ignoreUnknownKeys;

    public BsonDecoder(@NotNull BsonValue value, @NotNull SerializersModule serializersModule, boolean ignoreUnknownKeys) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        this.value = value;
        this.serializersModule = serializersModule;
        this.ignoreUnknownKeys = ignoreUnknownKeys;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return 0;
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            AbstractDecoder abstractDecoder;
            switch (WhenMappings.$EnumSwitchMapping$0[this.currentValue().getBsonType().ordinal()]) {
                case 1: {
                    abstractDecoder = new ListBsonBinaryDecoder(this.currentValue().asBinary(), this.getSerializersModule());
                    break;
                }
                case 2: {
                    abstractDecoder = new ListBsonDecoder((BsonArray)this.rethrowAsSerializationException((Function0)new Function0<BsonArray>(this){
                        final /* synthetic */ BsonDecoder this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final BsonArray invoke() {
                            return this.this$0.currentValue().asArray();
                        }
                    }), this.getSerializersModule(), this.ignoreUnknownKeys);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported".toString());
                }
            }
            compositeDecoder = (CompositeDecoder)abstractDecoder;
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            compositeDecoder = (CompositeDecoder)new MapBsonDecoder((BsonDocument)this.rethrowAsSerializationException((Function0)new Function0<BsonDocument>(this){
                final /* synthetic */ BsonDecoder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final BsonDocument invoke() {
                    return this.this$0.currentValue().asDocument();
                }
            }), this.getSerializersModule(), this.ignoreUnknownKeys);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE)) {
            BsonDocument $this$beginStructure_u24lambda_u2d1 = (BsonDocument)this.rethrowAsSerializationException((Function0)new Function0<BsonDocument>(this){
                final /* synthetic */ BsonDecoder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final BsonDocument invoke() {
                    return this.this$0.currentValue().asDocument();
                }
            });
            boolean bl = false;
            if (!this.ignoreUnknownKeys) {
                Map $this$forEach$iv = $this$beginStructure_u24lambda_u2d1;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (descriptor.getElementIndex((String)entry.getKey()) != -3) continue;
                    throw new SerializationException("Could not decode class `" + descriptor.getSerialName() + "`, encountered unknown key `" + (String)entry.getKey() + "`.");
                }
            }
            compositeDecoder = (CompositeDecoder)new ClassBsonDecoder($this$beginStructure_u24lambda_u2d1, this.getSerializersModule(), this.ignoreUnknownKeys);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            compositeDecoder = (CompositeDecoder)new ClassBsonDecoder(new BsonDocument(null, 1, null), this.getSerializersModule(), this.ignoreUnknownKeys);
        } else {
            if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.OPEN.INSTANCE) ? true : Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.SEALED.INSTANCE)) {
                throw new SerializationException("Polymorphic values are not supported.");
            }
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unsupported descriptor kind ", (Object)descriptor.getKind()).toString());
        }
        return compositeDecoder;
    }

    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<T> deserializer) {
        Object object;
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        if (this.currentValue() instanceof BsonNull) {
            BsonDecoder this_$iv = this;
            boolean $i$f$fastPathBsonNull = false;
            DeserializationStrategy<T> deserializationStrategy = deserializer;
            object = (deserializationStrategy instanceof BsonValueSerializer ? true : deserializationStrategy instanceof BsonNullSerializer) ? BsonNull.INSTANCE : null;
        } else if (deserializer instanceof BsonSerializer) {
            BsonValue bsonValue;
            BsonDecoder this_$iv = this;
            BsonSerializer deserializer$iv = (BsonSerializer)deserializer;
            boolean $i$f$fastPathBsonValue = false;
            if (this_$iv.currentValue().isNumber()) {
                BsonNumber bsonNumber;
                BsonNumber bsonNumber$iv = this_$iv.currentValue().asNumber();
                BsonSerializer bsonSerializer = deserializer$iv;
                if (bsonSerializer instanceof BsonInt32Serializer) {
                    bsonNumber = new BsonInt32(bsonNumber$iv.intValue());
                } else if (bsonSerializer instanceof BsonInt64Serializer) {
                    bsonNumber = new BsonInt64(bsonNumber$iv.longValue());
                } else if (bsonSerializer instanceof BsonDoubleSerializer) {
                    bsonNumber = new BsonDouble(bsonNumber$iv.doubleValue());
                } else {
                    throw new IllegalStateException("Could not deserialize BsonNumber".toString());
                }
                bsonValue = bsonNumber;
            } else {
                bsonValue = this_$iv.currentValue();
            }
            object = bsonValue;
        } else {
            object = super.decodeSerializableValue(deserializer);
        }
        return (T)object;
    }

    private final <T> T fastPathBsonValue(BsonSerializer deserializer) {
        BsonValue bsonValue;
        boolean $i$f$fastPathBsonValue = false;
        if (this.currentValue().isNumber()) {
            BsonNumber bsonNumber;
            BsonNumber bsonNumber2 = this.currentValue().asNumber();
            BsonSerializer bsonSerializer = deserializer;
            if (bsonSerializer instanceof BsonInt32Serializer) {
                bsonNumber = new BsonInt32(bsonNumber2.intValue());
            } else if (bsonSerializer instanceof BsonInt64Serializer) {
                bsonNumber = new BsonInt64(bsonNumber2.longValue());
            } else if (bsonSerializer instanceof BsonDoubleSerializer) {
                bsonNumber = new BsonDouble(bsonNumber2.doubleValue());
            } else {
                throw new IllegalStateException("Could not deserialize BsonNumber".toString());
            }
            bsonValue = bsonNumber;
        } else {
            bsonValue = this.currentValue();
        }
        return (T)bsonValue;
    }

    private final <T> T fastPathBsonNull(DeserializationStrategy<T> deserializer) {
        boolean $i$f$fastPathBsonNull = false;
        DeserializationStrategy<T> deserializationStrategy = deserializer;
        return (T)((deserializationStrategy instanceof BsonValueSerializer ? true : deserializationStrategy instanceof BsonNullSerializer) ? BsonNull.INSTANCE : null);
    }

    public int decodeInt() {
        return ((Number)this.rethrowAsSerializationException((Function0)new Function0<Integer>(this){
            final /* synthetic */ BsonDecoder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.this$0.currentValue().asNumber().intValue();
            }
        })).intValue();
    }

    @NotNull
    public String decodeString() {
        return (String)this.rethrowAsSerializationException((Function0)new Function0<String>(this){
            final /* synthetic */ BsonDecoder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.this$0.currentValue().asString().getValue();
            }
        });
    }

    public boolean decodeBoolean() {
        return (Boolean)this.rethrowAsSerializationException((Function0)new Function0<Boolean>(this){
            final /* synthetic */ BsonDecoder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.this$0.currentValue().asBoolean().getValue();
            }
        });
    }

    public byte decodeByte() {
        return ((Number)this.rethrowAsSerializationException((Function0)new Function0<Byte>(this){
            final /* synthetic */ BsonDecoder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Byte invoke() {
                return (byte)this.this$0.currentValue().asNumber().intValue();
            }
        })).byteValue();
    }

    public char decodeChar() {
        return ((Character)this.rethrowAsSerializationException((Function0)new Function0<Character>(this){
            final /* synthetic */ BsonDecoder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Character invoke() {
                char c;
                BsonValue value = this.this$0.currentValue();
                if (value instanceof BsonString) {
                    c = value.asString().getValue().charAt(0);
                } else if (value instanceof BsonNumber) {
                    c = String.valueOf(value.asNumber().intValue()).charAt(0);
                } else {
                    throw new IllegalStateException(("Cannot decode " + value + " as a Char.").toString());
                }
                return Character.valueOf(c);
            }
        })).charValue();
    }

    public double decodeDouble() {
        return ((Number)this.rethrowAsSerializationException((Function0)new Function0<Double>(this){
            final /* synthetic */ BsonDecoder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Double invoke() {
                return this.this$0.currentValue().asNumber().doubleValue();
            }
        })).doubleValue();
    }

    public float decodeFloat() {
        return ((Number)this.rethrowAsSerializationException((Function0)new Function0<Float>(this){
            final /* synthetic */ BsonDecoder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Float invoke() {
                return Float.valueOf((float)this.this$0.currentValue().asNumber().doubleValue());
            }
        })).floatValue();
    }

    public long decodeLong() {
        return ((Number)this.rethrowAsSerializationException((Function0)new Function0<Long>(this){
            final /* synthetic */ BsonDecoder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return this.this$0.currentValue().asNumber().longValue();
            }
        })).longValue();
    }

    public short decodeShort() {
        return ((Number)this.rethrowAsSerializationException((Function0)new Function0<Short>(this){
            final /* synthetic */ BsonDecoder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Short invoke() {
                return (short)this.this$0.currentValue().asNumber().intValue();
            }
        })).shortValue();
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        String name = this.currentValue().asString().getValue();
        return enumDescriptor.getElementIndex(name);
    }

    @NotNull
    public BsonValue currentValue() {
        return this.value;
    }

    public <T> T rethrowAsSerializationException(@NotNull Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            object = block.invoke();
        }
        catch (BsonInvalidOperationException e) {
            throw new SerializationException(e.getMessage(), (Throwable)e);
        }
        return (T)object;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BsonType.values().length];
            nArray[BsonType.BINARY.ordinal()] = 1;
            nArray[BsonType.ARRAY.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

