/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.processor;

import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.MessageFactory;
import org.mule.security.oauth.exception.AuthorizationCodeNotFoundException;
import org.mule.transport.NullPayload;

public class ExtractAuthorizationCodeMessageProcessor
implements MessageProcessor {
    private Pattern pattern;

    public ExtractAuthorizationCodeMessageProcessor(Pattern pattern) {
        this.pattern = pattern;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        try {
            event.getMessage().setInvocationProperty("_oauthVerifier", (Object)this.extractAuthorizationCode(event));
        }
        catch (Exception e) {
            throw new MessagingException(MessageFactory.createStaticMessage((String)"Could not extract OAuth verifier"), event, (Throwable)e);
        }
        return event;
    }

    private String extractAuthorizationCode(MuleEvent event) throws Exception {
        Matcher matcher;
        String response;
        if (event.getMessage().getPayload() instanceof NullPayload) {
            response = (String)event.getMessage().getInboundProperty("http.query.string");
            if (StringUtils.isBlank((String)response)) {
                throw new AuthorizationCodeNotFoundException(this.pattern, response);
            }
        } else {
            response = event.getMessageAsString();
        }
        if ((matcher = this.pattern.matcher(response)).find() && matcher.groupCount() >= 1) {
            return URLDecoder.decode(matcher.group(1), "UTF-8");
        }
        throw new AuthorizationCodeNotFoundException(this.pattern, response);
    }
}

