/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.util;

import com.google.common.base.Predicate;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.mule.api.NestedProcessor;
import org.mule.extension.annotations.Operation;
import org.mule.extension.annotations.ParameterGroup;
import org.mule.extension.annotations.param.Ignore;
import org.mule.extension.annotations.param.Optional;
import org.mule.extension.introspection.Capable;
import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.Parameter;
import org.mule.extension.introspection.declaration.ParameterDeclaration;
import org.mule.module.extension.internal.introspection.MuleExtensionAnnotationParser;
import org.mule.util.ClassUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.Preconditions;
import org.reflections.ReflectionUtils;
import org.springframework.core.ResolvableType;

public class IntrospectionUtils {
    public static DataType getClassDataType(Class<?> clazz) {
        return IntrospectionUtils.toDataType(ResolvableType.forClass(clazz));
    }

    public static DataType getMethodReturnType(Method method) {
        Preconditions.checkArgument((method != null ? 1 : 0) != 0, (String)"Can't introspect a null method");
        return IntrospectionUtils.toDataType(ResolvableType.forMethodReturnType((Method)method));
    }

    public static DataType[] getMethodArgumentTypes(Method method) {
        Preconditions.checkArgument((method != null ? 1 : 0) != 0, (String)"Can't introspect a null method");
        Object[] parameters = method.getParameterTypes();
        if (org.mule.util.ArrayUtils.isEmpty((Object[])parameters)) {
            return new DataType[0];
        }
        DataType[] types = new DataType[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            ResolvableType type = ResolvableType.forMethodParameter((Method)method, (int)i);
            types[i] = IntrospectionUtils.toDataType(type);
        }
        return types;
    }

    public static DataType getFieldDataType(Field field) {
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Can't introspect a null field");
        return IntrospectionUtils.toDataType(ResolvableType.forField((Field)field));
    }

    public static Field getField(Class<?> clazz, Parameter parameter) {
        return IntrospectionUtils.getField(clazz, MuleExtensionAnnotationParser.getMemberName((Capable)parameter, parameter.getName()), parameter.getType().getRawType());
    }

    public static Field getField(Class<?> clazz, ParameterDeclaration parameterDeclaration) {
        return IntrospectionUtils.getField(clazz, MuleExtensionAnnotationParser.getMemberName((Capable)parameterDeclaration, parameterDeclaration.getName()), parameterDeclaration.getType().getRawType());
    }

    public static Field getField(Class<?> clazz, String name, Class<?> type) {
        Set candidates = ReflectionUtils.getAllFields(clazz, (Predicate[])new Predicate[]{ReflectionUtils.withName((String)name), ReflectionUtils.withTypeAssignableTo(type)});
        return CollectionUtils.isEmpty((Collection)candidates) ? null : (Field)candidates.iterator().next();
    }

    public static boolean hasDefaultConstructor(Class<?> clazz) {
        return ClassUtils.getConstructor(clazz, (Class[])new Class[0]) != null;
    }

    private static DataType toDataType(ResolvableType type) {
        Class rawClass = type.getRawClass();
        Object[] generics = type.getGenerics();
        if (IntrospectionUtils.isOperation(rawClass)) {
            return DataType.of(org.mule.extension.introspection.Operation.class);
        }
        if (List.class.isAssignableFrom(rawClass) && !org.mule.util.ArrayUtils.isEmpty((Object[])generics) && IntrospectionUtils.isOperation(generics[0].getRawClass())) {
            return DataType.of((Class)rawClass, (Class[])new Class[]{org.mule.extension.introspection.Operation.class});
        }
        return DataType.of((Class)rawClass, (Class[])IntrospectionUtils.toRawTypes((ResolvableType[])generics));
    }

    private static boolean isOperation(Class<?> rawClass) {
        return NestedProcessor.class.isAssignableFrom(rawClass);
    }

    private static Class<?>[] toRawTypes(ResolvableType[] resolvableTypes) {
        Class[] types = new Class[resolvableTypes.length];
        for (int i = 0; i < resolvableTypes.length; ++i) {
            types[i] = resolvableTypes[i].getRawClass();
        }
        return types;
    }

    public static void checkInstantiable(Class<?> declaringClass) {
        IntrospectionUtils.checkInstantiable(declaringClass, true);
    }

    public static void checkInstantiable(Class<?> declaringClass, boolean requireDefaultConstructor) {
        Preconditions.checkArgument((declaringClass != null ? 1 : 0) != 0, (String)"declaringClass cannot be null");
        if (requireDefaultConstructor) {
            Preconditions.checkArgument((boolean)IntrospectionUtils.hasDefaultConstructor(declaringClass), (String)String.format("Class %s cannot be instantiated since it doesn't have a default constructor", declaringClass.getName()));
        }
        Preconditions.checkArgument((!declaringClass.isInterface() ? 1 : 0) != 0, (String)String.format("Class %s cannot be instantiated since it's an interface", declaringClass.getName()));
        Preconditions.checkArgument((!Modifier.isAbstract(declaringClass.getModifiers()) ? 1 : 0) != 0, (String)String.format("Class %s cannot be instantiated since it's abstract", declaringClass.getName()));
    }

    public static boolean isIgnored(AccessibleObject object) {
        return object == null || object.getAnnotation(Ignore.class) != null;
    }

    public static boolean isRequired(AccessibleObject object) {
        return object.getAnnotation(Optional.class) == null;
    }

    public static boolean isRequired(Parameter parameter, boolean forceOptional) {
        return !forceOptional && parameter.isRequired();
    }

    public static boolean isDynamic(AccessibleObject object) {
        org.mule.extension.annotations.Parameter parameter = object.getAnnotation(org.mule.extension.annotations.Parameter.class);
        return parameter != null ? parameter.isDynamic() : true;
    }

    public static boolean isVoid(Method method) {
        Class<?> returnType = method.getReturnType();
        return returnType.equals(Void.TYPE) || returnType.equals(Void.class);
    }

    public static Collection<Field> getParameterFields(Class<?> extensionType) {
        return ReflectionUtils.getAllFields(extensionType, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(org.mule.extension.annotations.Parameter.class)});
    }

    public static Collection<Field> getParameterGroupFields(Class<?> extensionType) {
        return ReflectionUtils.getAllFields(extensionType, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(ParameterGroup.class)});
    }

    public static Collection<Method> getOperationMethods(Class<?> declaringClass) {
        return ReflectionUtils.getAllMethods(declaringClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Operation.class), ReflectionUtils.withModifier((int)1)});
    }

    public static Method getOperationMethod(Class<?> declaringClass, org.mule.extension.introspection.Operation operation) {
        Class[] parameterTypes;
        if (operation.getParameters().isEmpty()) {
            parameterTypes = ArrayUtils.EMPTY_CLASS_ARRAY;
        } else {
            parameterTypes = new Class[operation.getParameters().size()];
            int i = 0;
            for (Parameter parameter : operation.getParameters()) {
                parameterTypes[i++] = parameter.getType().getRawType();
            }
        }
        Set methods = ReflectionUtils.getAllMethods(declaringClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Operation.class), ReflectionUtils.withModifier((int)1), ReflectionUtils.withName((String)operation.getName()), ReflectionUtils.withParameters((Class[])parameterTypes)});
        Preconditions.checkArgument((!methods.isEmpty() ? 1 : 0) != 0, (String)String.format("Could not find method %s in class %s", operation.getName(), declaringClass.getName()));
        Preconditions.checkArgument((methods.size() == 1 ? 1 : 0) != 0, (String)String.format("More than one matching method was found in class %s for operation %s", declaringClass.getName(), operation.getName()));
        return (Method)methods.iterator().next();
    }

    public static String getAlias(Field field) {
        org.mule.extension.annotations.Parameter parameter = field.getAnnotation(org.mule.extension.annotations.Parameter.class);
        String alias = parameter != null ? parameter.alias() : "";
        return StringUtils.isEmpty((String)alias) ? field.getName() : alias;
    }
}

