/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import java.io.ByteArrayInputStream;
import org.mule.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.module.http.internal.domain.request.HttpRequestContext;
import org.mule.module.http.internal.domain.response.HttpResponseBuilder;
import org.mule.module.http.internal.listener.async.HttpResponseReadyCallback;
import org.mule.module.http.internal.listener.async.RequestHandler;
import org.mule.module.http.internal.listener.async.ResponseStatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorRequestHandler
implements RequestHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int statusCode;
    private String reasonPhraseFormat;
    private String entity;

    public ErrorRequestHandler(int statusCode, String reasonPhraseFormat, String entity) {
        this.statusCode = statusCode;
        this.reasonPhraseFormat = reasonPhraseFormat;
        this.entity = entity;
    }

    @Override
    public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
        responseCallback.responseReady(new HttpResponseBuilder().setStatusCode(this.statusCode).setReasonPhrase(String.format(this.reasonPhraseFormat, requestContext.getRequest().getUri())).setEntity(new InputStreamHttpEntity(new ByteArrayInputStream(this.entity.getBytes()))).build(), new ResponseStatusCallback(){

            @Override
            public void responseSendFailure(Throwable exception) {
                ErrorRequestHandler.this.logger.warn(String.format("Error while sending %s response %s", ErrorRequestHandler.this.statusCode, exception.getMessage()));
                if (ErrorRequestHandler.this.logger.isDebugEnabled()) {
                    ErrorRequestHandler.this.logger.debug("exception thrown", exception);
                }
            }

            @Override
            public void responseSendSuccessfully() {
            }
        });
    }
}

