/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.multipart;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.servlet.http.Part;
import org.mule.module.http.internal.HttpParser;
import org.mule.module.http.internal.domain.MultipartHttpEntity;
import org.mule.module.http.internal.multipart.HttpMimeMultipart;
import org.mule.module.http.internal.multipart.HttpPart;
import org.mule.util.IOUtils;

public class HttpMultipartEncoder {
    public static MimeMultipart createMultpartContent(MultipartHttpEntity body, String contentType) {
        HttpMimeMultipart mimeMultipartContent = new HttpMimeMultipart(contentType, HttpParser.getContentTypeSubType(contentType));
        Collection<HttpPart> parts = body.getParts();
        for (Part part : parts) {
            InternetHeaders internetHeaders = new InternetHeaders();
            for (String headerName : part.getHeaderNames()) {
                Collection headerValues = part.getHeaders(headerName);
                for (String headerValue : headerValues) {
                    internetHeaders.addHeader(headerName, headerValue);
                }
            }
            if (part.getContentType() != null) {
                internetHeaders.addHeader("Content-Type", part.getContentType());
            }
            try {
                byte[] partContent = IOUtils.toByteArray((InputStream)part.getInputStream());
                mimeMultipartContent.addBodyPart((BodyPart)new MimeBodyPart(internetHeaders, partContent));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return mimeMultipartContent;
    }

    public static byte[] createMultipartContent(MultipartHttpEntity multipartEntity, String contentType) throws IOException, MessagingException {
        MimeMultipart mimeMultipartContent = HttpMultipartEncoder.createMultpartContent(multipartEntity, contentType);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        mimeMultipartContent.writeTo((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

