/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.domain.request;

import org.mule.module.http.internal.HttpParser;
import org.mule.module.http.internal.ParameterMap;
import org.mule.module.http.internal.domain.HttpEntity;
import org.mule.module.http.internal.domain.request.DefaultHttpRequest;
import org.mule.module.http.internal.domain.request.HttpRequest;

public class HttpRequestBuilder {
    private String path;
    private String uri;
    private String method;
    private ParameterMap headers;
    private ParameterMap queryParams;
    private HttpEntity entity;

    public HttpRequestBuilder setUri(String uri) {
        this.path = HttpParser.extractPath(uri.toString());
        this.uri = uri;
        return this;
    }

    public HttpRequestBuilder setMethod(String method) {
        this.method = method;
        return this;
    }

    public HttpRequestBuilder setHeaders(ParameterMap headers) {
        this.headers = headers;
        return this;
    }

    public HttpRequestBuilder addHeader(String headerName, String headerValue) {
        this.headers.put(headerName, headerValue);
        return this;
    }

    public HttpRequestBuilder removeHeader(String headerName) {
        this.headers.remove(headerName);
        return this;
    }

    public ParameterMap getHeaders() {
        return this.headers;
    }

    public HttpRequestBuilder setQueryParams(ParameterMap queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public HttpRequestBuilder setEntity(HttpEntity entity) {
        this.entity = entity;
        return this;
    }

    public HttpRequest build() {
        return new DefaultHttpRequest(this.uri, this.path, this.method, this.headers == null ? null : this.headers.toImmutableParameterMap(), this.queryParams == null ? this.queryParams : this.queryParams.toImmutableParameterMap(), this.entity);
    }
}

