/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request;

import java.net.CookieManager;
import org.mule.AbstractAnnotatedObject;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleUtils;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.http.api.HttpAuthentication;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.requester.HttpRequesterConfig;
import org.mule.module.http.api.requester.HttpSendBodyMode;
import org.mule.module.http.api.requester.HttpStreamingType;
import org.mule.module.http.api.requester.proxy.ProxyConfig;
import org.mule.module.http.internal.request.HttpClient;
import org.mule.module.http.internal.request.HttpClientConfiguration;
import org.mule.module.http.internal.request.HttpClientFactory;
import org.mule.module.http.internal.request.RamlApiConfiguration;
import org.mule.module.http.internal.request.grizzly.GrizzlyHttpClient;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.transport.ssl.api.TlsContextFactoryBuilder;
import org.mule.transport.tcp.DefaultTcpClientSocketProperties;
import org.mule.transport.tcp.TcpClientSocketProperties;
import org.mule.util.concurrent.ThreadNameHelper;

public class DefaultHttpRequesterConfig
extends AbstractAnnotatedObject
implements HttpRequesterConfig,
Initialisable,
Stoppable,
Startable,
MuleContextAware {
    public static final String OBJECT_HTTP_CLIENT_FACTORY = "_httpClientFactory";
    private static final int UNLIMITED_CONNECTIONS = -1;
    private static final int DEFAULT_CONNECTION_IDLE_TIMEOUT = 30000;
    private static final String THREAD_NAME_PREFIX_PATTERN = "%shttp.requester.%s";
    private HttpConstants.Protocols protocol = HttpConstants.Protocols.HTTP;
    private String name;
    private String host;
    private String port;
    private String basePath = "/";
    private String followRedirects = Boolean.toString(true);
    private String requestStreamingMode = HttpStreamingType.AUTO.name();
    private String sendBodyMode = HttpSendBodyMode.AUTO.name();
    private String parseResponse = Boolean.toString(true);
    private String responseTimeout;
    private HttpAuthentication authentication;
    private TlsContextFactory tlsContext;
    private TcpClientSocketProperties clientSocketProperties = new DefaultTcpClientSocketProperties();
    private RamlApiConfiguration apiConfiguration;
    private ProxyConfig proxyConfig;
    private HttpClient httpClient;
    private int maxConnections = -1;
    private boolean usePersistentConnections = true;
    private int connectionIdleTimeout = 30000;
    private boolean enableCookies = false;
    private CookieManager cookieManager;
    private MuleContext muleContext;

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.authentication);
        this.verifyConnectionsParameters();
        if (this.port == null) {
            this.port = String.valueOf(this.protocol.getDefaultPort());
        }
        if (this.protocol.equals((Object)HttpConstants.Protocols.HTTP) && this.tlsContext != null) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"TlsContext cannot be configured with protocol HTTP, when using tls:context you must set attribute protocol=\"HTTPS\""), (Initialisable)this);
        }
        if (this.protocol.equals((Object)HttpConstants.Protocols.HTTPS) && this.tlsContext == null) {
            this.tlsContext = new TlsContextFactoryBuilder(this.muleContext).buildDefault();
        }
        if (this.enableCookies) {
            this.cookieManager = new CookieManager();
        }
        String threadNamePrefix = String.format(THREAD_NAME_PREFIX_PATTERN, ThreadNameHelper.getPrefix((MuleContext)this.muleContext), this.name);
        HttpClientConfiguration configuration = new HttpClientConfiguration.Builder().setTlsContextFactory(this.tlsContext).setProxyConfig(this.proxyConfig).setClientSocketProperties(this.clientSocketProperties).setMaxConnections(this.maxConnections).setUsePersistentConnections(this.usePersistentConnections).setConnectionIdleTimeout(this.connectionIdleTimeout).setThreadNamePrefix(threadNamePrefix).setOwnerName(this.name).build();
        HttpClientFactory httpClientFactory = (HttpClientFactory)this.muleContext.getRegistry().get(OBJECT_HTTP_CLIENT_FACTORY);
        this.httpClient = httpClientFactory == null ? new GrizzlyHttpClient(configuration) : httpClientFactory.create(configuration);
        this.httpClient.initialise();
    }

    private void verifyConnectionsParameters() throws InitialisationException {
        if (this.maxConnections < -1 || this.maxConnections == 0) {
            throw new InitialisationException(CoreMessages.createStaticMessage((String)"The maxConnections parameter only allows positive values or -1 for unlimited concurrent connections."), (Initialisable)this);
        }
        if (!this.usePersistentConnections) {
            this.connectionIdleTimeout = 0;
        }
    }

    public void stop() throws MuleException {
        this.httpClient.stop();
        if (this.authentication instanceof Stoppable) {
            ((Stoppable)this.authentication).stop();
        }
    }

    public String getScheme() {
        if (this.tlsContext == null) {
            return "http";
        }
        return "https";
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public HttpAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(HttpAuthentication authentication) {
        this.authentication = authentication;
    }

    @Override
    public TlsContextFactory getTlsContext() {
        return this.tlsContext;
    }

    public void setTlsContext(TlsContextFactory tlsContext) {
        this.tlsContext = tlsContext;
    }

    public RamlApiConfiguration getApiConfiguration() {
        return this.apiConfiguration;
    }

    public void setApiConfiguration(RamlApiConfiguration apiConfiguration) {
        this.apiConfiguration = apiConfiguration;
    }

    @Override
    public String getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(String followRedirects) {
        this.followRedirects = followRedirects;
    }

    public TcpClientSocketProperties getClientSocketProperties() {
        return this.clientSocketProperties;
    }

    public void setClientSocketProperties(TcpClientSocketProperties clientSocketProperties) {
        this.clientSocketProperties = clientSocketProperties;
    }

    @Override
    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    @Override
    public String getRequestStreamingMode() {
        return this.requestStreamingMode;
    }

    public void setRequestStreamingMode(String requestStreamingMode) {
        this.requestStreamingMode = requestStreamingMode;
    }

    @Override
    public String getSendBodyMode() {
        return this.sendBodyMode;
    }

    public void setSendBodyMode(String sendBodyMode) {
        this.sendBodyMode = sendBodyMode;
    }

    @Override
    public String getParseResponse() {
        return this.parseResponse;
    }

    public void setParseResponse(String parseResponse) {
        this.parseResponse = parseResponse;
    }

    @Override
    public String getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(String responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public void start() throws MuleException {
        if (this.authentication instanceof Startable) {
            ((Startable)this.authentication).start();
        }
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setUsePersistentConnections(boolean usePersistentConnections) {
        this.usePersistentConnections = usePersistentConnections;
    }

    public void setConnectionIdleTimeout(int connectionIdleTimeout) {
        this.connectionIdleTimeout = connectionIdleTimeout;
    }

    public boolean isEnableCookies() {
        return this.enableCookies;
    }

    public void setEnableCookies(boolean enableCookies) {
        this.enableCookies = enableCookies;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setProtocol(HttpConstants.Protocols protocol) {
        this.protocol = protocol;
    }
}

