/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener.grizzly;

import java.io.InputStream;
import java.util.Collection;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.utils.BufferInputStream;
import org.mule.api.MuleRuntimeException;
import org.mule.module.http.internal.HttpParser;
import org.mule.module.http.internal.ParameterMap;
import org.mule.module.http.internal.domain.BaseHttpMessage;
import org.mule.module.http.internal.domain.EmptyHttpEntity;
import org.mule.module.http.internal.domain.HttpEntity;
import org.mule.module.http.internal.domain.HttpProtocol;
import org.mule.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.module.http.internal.domain.MultipartHttpEntity;
import org.mule.module.http.internal.domain.request.HttpRequest;
import org.mule.module.http.internal.listener.grizzly.BlockingTransferInputStream;
import org.mule.module.http.internal.multipart.HttpPart;
import org.mule.util.StringUtils;

public class GrizzlyHttpRequestAdapter
extends BaseHttpMessage
implements HttpRequest {
    private final HttpRequestPacket requestPacket;
    private final InputStream requestContent;
    private final FilterChainContext filterChainContext;
    private final int contentLength;
    private final boolean isTransferEncodingChunked;
    private HttpProtocol protocol;
    private String uri;
    private String path;
    private String method;
    private HttpEntity body;
    private ParameterMap headers;

    public GrizzlyHttpRequestAdapter(FilterChainContext filterChainContext, HttpContent httpContent) {
        boolean contentIsIncomplete;
        this.filterChainContext = filterChainContext;
        this.requestPacket = (HttpRequestPacket)httpContent.getHttpHeader();
        this.isTransferEncodingChunked = httpContent.getHttpHeader().isChunked();
        int contentLengthAsInt = 0;
        String contentLengthAsString = this.requestPacket.getHeader("Content-Length");
        if (contentLengthAsString != null) {
            contentLengthAsInt = Integer.parseInt(contentLengthAsString);
        }
        this.contentLength = contentLengthAsInt;
        Object contentInputStream = new BufferInputStream(httpContent.getContent());
        boolean bl = contentIsIncomplete = !httpContent.isLast();
        if (contentIsIncomplete) {
            contentInputStream = new BlockingTransferInputStream(filterChainContext, (InputStream)contentInputStream);
        }
        this.requestContent = contentInputStream;
    }

    @Override
    public HttpProtocol getProtocol() {
        if (this.protocol == null) {
            this.protocol = this.requestPacket.getProtocol() == Protocol.HTTP_1_0 ? HttpProtocol.HTTP_1_0 : HttpProtocol.HTTP_1_1;
        }
        return this.protocol;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            String uri = this.getUri();
            this.path = HttpParser.extractPath(uri);
        }
        return this.path;
    }

    @Override
    public String getMethod() {
        if (this.method == null) {
            this.method = this.requestPacket.getMethod().getMethodString();
        }
        return this.method;
    }

    @Override
    public Collection<String> getHeaderNames() {
        if (this.headers == null) {
            this.initializeHeaders();
        }
        return this.headers.keySet();
    }

    @Override
    public String getHeaderValue(String headerName) {
        if (this.headers == null) {
            this.initializeHeaders();
        }
        return this.headers.get(headerName);
    }

    @Override
    public Collection<String> getHeaderValues(String headerName) {
        if (this.headers == null) {
            this.initializeHeaders();
        }
        return this.headers.getAll(headerName);
    }

    private void initializeHeaders() {
        this.headers = new ParameterMap();
        for (String grizzlyHeaderName : this.requestPacket.getHeaders().names()) {
            Iterable headerValues = this.requestPacket.getHeaders().values(grizzlyHeaderName);
            for (String headerValue : headerValues) {
                this.headers.put(grizzlyHeaderName, headerValue);
            }
        }
        this.headers = this.headers.toImmutableParameterMap();
    }

    @Override
    public HttpEntity getEntity() {
        try {
            if (this.body == null) {
                String contentTypeValue = this.getHeaderValueIgnoreCase("Content-Type");
                if (contentTypeValue != null && contentTypeValue.contains("multipart")) {
                    Collection<HttpPart> parts = HttpParser.parseMultipartContent(this.requestContent, contentTypeValue);
                    this.body = new MultipartHttpEntity(parts);
                } else {
                    this.body = this.isTransferEncodingChunked ? new InputStreamHttpEntity(this.requestContent) : (this.contentLength > 0 ? new InputStreamHttpEntity(this.contentLength, this.requestContent) : new EmptyHttpEntity());
                }
            }
            return this.body;
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getUri() {
        if (this.uri == null) {
            this.uri = this.requestPacket.getRequestURI() + (StringUtils.isEmpty((String)this.requestPacket.getQueryString()) ? "" : "?" + this.requestPacket.getQueryString());
        }
        return this.uri;
    }

    @Override
    public InputStreamHttpEntity getInputStreamEntity() {
        if (this.requestContent == null) {
            return null;
        }
        if (this.isTransferEncodingChunked) {
            return new InputStreamHttpEntity(this.requestContent);
        }
        if (this.contentLength > 0) {
            return new InputStreamHttpEntity(this.contentLength, this.requestContent);
        }
        return null;
    }
}

