/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.multipart;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.mule.api.MuleRuntimeException;
import org.mule.message.ds.ByteArrayDataSource;
import org.mule.module.http.internal.multipart.HttpPart;
import org.mule.util.IOUtils;

public class HttpPartDataSource
implements DataSource {
    public static final String ANONYMOUS_ATTACHMENT_FORMAT = "mule_attachment_%d";
    private final HttpPart part;
    private byte[] content;

    private HttpPartDataSource(HttpPart part) {
        try {
            this.part = part;
            this.content = IOUtils.toByteArray((InputStream)part.getInputStream());
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public byte[] getContent() throws IOException {
        return this.content;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getContent());
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getContentType() {
        return this.part.getContentType();
    }

    public String getHeader(String headerName) {
        return this.part.getHeader(headerName);
    }

    public String getName() {
        return this.part.getName();
    }

    public static Collection<HttpPartDataSource> createFrom(Collection<HttpPart> parts) {
        ArrayList<HttpPartDataSource> httpParts = new ArrayList<HttpPartDataSource>(parts.size());
        for (HttpPart part : parts) {
            httpParts.add(new HttpPartDataSource(part));
        }
        return httpParts;
    }

    public static Map<String, DataHandler> createDataHandlerFrom(Collection<HttpPart> parts) {
        LinkedHashMap<String, DataHandler> httpParts = new LinkedHashMap<String, DataHandler>(parts.size());
        int anonymousPartCount = 0;
        for (HttpPart part : parts) {
            httpParts.put(part.getName() == null ? String.format(ANONYMOUS_ATTACHMENT_FORMAT, anonymousPartCount++) : part.getName(), new DataHandler((DataSource)new HttpPartDataSource(part)));
        }
        return httpParts;
    }

    public static Collection<HttpPart> createFrom(Map<String, DataHandler> parts) throws IOException {
        ArrayList<HttpPart> httpParts = new ArrayList<HttpPart>(parts.size());
        for (String partName : parts.keySet()) {
            DataHandler dataHandlerPart = parts.get(partName);
            if (dataHandlerPart.getDataSource() instanceof HttpPartDataSource) {
                httpParts.add(((HttpPartDataSource)dataHandlerPart.getDataSource()).getPart());
                continue;
            }
            byte[] data = IOUtils.toByteArray((InputStream)dataHandlerPart.getInputStream());
            String fileName = null;
            if (dataHandlerPart.getDataSource() instanceof FileDataSource || dataHandlerPart.getDataSource() instanceof ByteArrayDataSource) {
                fileName = dataHandlerPart.getDataSource().getName();
            }
            httpParts.add(new HttpPart(partName, fileName, data, dataHandlerPart.getContentType(), data.length));
        }
        return httpParts;
    }

    public HttpPart getPart() {
        return this.part;
    }
}

