/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.module.http.api.requester.HttpSendBodyMode;
import org.mule.module.http.api.requester.HttpStreamingType;
import org.mule.module.http.internal.HttpParser;
import org.mule.module.http.internal.domain.ByteArrayHttpEntity;
import org.mule.module.http.internal.domain.EmptyHttpEntity;
import org.mule.module.http.internal.domain.HttpEntity;
import org.mule.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.module.http.internal.domain.MultipartHttpEntity;
import org.mule.module.http.internal.domain.request.HttpRequestBuilder;
import org.mule.module.http.internal.multipart.HttpPartDataSource;
import org.mule.module.http.internal.request.DefaultHttpRequester;
import org.mule.module.http.internal.request.HttpRequesterRequestBuilder;
import org.mule.transport.NullPayload;
import org.mule.util.AttributeEvaluator;
import org.mule.util.DataTypeUtils;
import org.mule.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleEventToHttpRequest {
    private static final Logger logger = LoggerFactory.getLogger(MuleEventToHttpRequest.class);
    private static final List<String> ignoredProperties = Arrays.asList("Connection", "Host", "Transfer-Encoding");
    private static final String APPLICATION_JAVA = "application/java";
    private DefaultHttpRequester requester;
    private MuleContext muleContext;
    private AttributeEvaluator requestStreamingMode;
    private AttributeEvaluator sendBody;

    public MuleEventToHttpRequest(DefaultHttpRequester requester, MuleContext muleContext, AttributeEvaluator requestStreamingMode, AttributeEvaluator sendBody) {
        this.requester = requester;
        this.muleContext = muleContext;
        this.requestStreamingMode = requestStreamingMode;
        this.sendBody = sendBody;
    }

    public HttpRequestBuilder create(MuleEvent event, String resolvedMethod, String resolvedUri) throws MessagingException {
        DataType dataType;
        HttpRequesterRequestBuilder requestBuilder = this.requester.getRequestBuilder();
        HttpRequestBuilder builder = new HttpRequestBuilder();
        builder.setUri(resolvedUri);
        builder.setMethod(resolvedMethod);
        builder.setHeaders(requestBuilder.getHeaders(event));
        builder.setQueryParams(requestBuilder.getQueryParams(event));
        for (String outboundProperty : event.getMessage().getOutboundPropertyNames()) {
            if (!this.isNotIgnoredProperty(outboundProperty)) continue;
            Object outboundPropertyValue = event.getMessage().getOutboundProperty(outboundProperty);
            if (outboundPropertyValue instanceof Iterable) {
                Iterable outboundIterable = (Iterable)outboundPropertyValue;
                for (Object value : outboundIterable) {
                    builder.addHeader(outboundProperty, value.toString());
                }
                continue;
            }
            builder.addHeader(outboundProperty, outboundPropertyValue.toString());
        }
        if (!(event.getMessage().getOutboundPropertyNames().contains("Content-Type") || builder.getHeaders().containsKey("Content-Type") || "*/*".equals((dataType = event.getMessage().getDataType()).getMimeType()))) {
            builder.addHeader("Content-Type", DataTypeUtils.getContentType((DataType)dataType));
        }
        if (this.requester.getConfig().isEnableCookies()) {
            try {
                Map<String, List<String>> headers = this.requester.getConfig().getCookieManager().get(URI.create(resolvedUri), Collections.emptyMap());
                List<String> cookies = headers.get("Cookie");
                if (cookies != null) {
                    for (String cookie : cookies) {
                        builder.addHeader("Cookie", cookie);
                    }
                }
            }
            catch (IOException e) {
                logger.warn("Error reading cookies for URI " + resolvedUri, (Throwable)e);
            }
        }
        builder.setEntity(this.createRequestEntity(builder, event, resolvedMethod));
        return builder;
    }

    private boolean isNotIgnoredProperty(String outboundProperty) {
        return !outboundProperty.startsWith("http.") && !this.equalsIgnoredProperty(outboundProperty);
    }

    private boolean equalsIgnoredProperty(final String outboundProperty) {
        return CollectionUtils.exists(ignoredProperties, (Predicate)new Predicate(){

            public boolean evaluate(Object propertyName) {
                return outboundProperty.equalsIgnoreCase((String)propertyName);
            }
        });
    }

    private HttpEntity createRequestEntity(HttpRequestBuilder requestBuilder, MuleEvent muleEvent, String resolvedMethod) throws MessagingException {
        boolean customSource = false;
        Object oldPayload = null;
        if (!StringUtils.isEmpty((String)this.requester.getSource()) && !"#[payload]".equals(this.requester.getSource())) {
            Object newPayload = this.muleContext.getExpressionManager().evaluate(this.requester.getSource(), muleEvent);
            oldPayload = muleEvent.getMessage().getPayload();
            muleEvent.getMessage().setPayload(newPayload);
            customSource = true;
        }
        HttpEntity entity = this.isEmptyBody(muleEvent, resolvedMethod) ? new EmptyHttpEntity() : this.createRequestEntityFromPayload(requestBuilder, muleEvent);
        if (customSource) {
            muleEvent.getMessage().setPayload(oldPayload);
        }
        return entity;
    }

    private boolean isEmptyBody(MuleEvent event, String method) {
        boolean emptyBody;
        HttpSendBodyMode sendBodyMode = this.resolveSendBodyMode(event);
        if (event.getMessage().getPayload() instanceof NullPayload && event.getMessage().getOutboundAttachmentNames().isEmpty()) {
            emptyBody = true;
        } else {
            emptyBody = DefaultHttpRequester.DEFAULT_EMPTY_BODY_METHODS.contains(method);
            if (sendBodyMode != HttpSendBodyMode.AUTO) {
                emptyBody = sendBodyMode == HttpSendBodyMode.NEVER;
            }
        }
        return emptyBody;
    }

    private HttpEntity createRequestEntityFromPayload(HttpRequestBuilder requestBuilder, MuleEvent muleEvent) throws MessagingException {
        Object payload = muleEvent.getMessage().getPayload();
        if (!muleEvent.getMessage().getOutboundAttachmentNames().isEmpty()) {
            try {
                return this.createMultiPart(muleEvent.getMessage());
            }
            catch (IOException e) {
                throw new MessagingException(muleEvent, (Throwable)e);
            }
        }
        if (this.doStreaming(requestBuilder, muleEvent)) {
            if (payload instanceof InputStream) {
                return new InputStreamHttpEntity((InputStream)payload);
            }
            try {
                return new InputStreamHttpEntity(new ByteArrayInputStream(muleEvent.getMessage().getPayloadAsBytes()));
            }
            catch (Exception e) {
                throw new MessagingException(muleEvent, (Throwable)e);
            }
        }
        String contentType = requestBuilder.getHeaders().get("Content-Type");
        if ((contentType == null || contentType.startsWith("application/x-www-form-urlencoded") || contentType.startsWith(APPLICATION_JAVA)) && muleEvent.getMessage().getPayload() instanceof Map) {
            String body = HttpParser.encodeString(muleEvent.getEncoding(), (Map)payload);
            requestBuilder.addHeader("Content-Type", "application/x-www-form-urlencoded");
            return new ByteArrayHttpEntity(body.getBytes());
        }
        try {
            return new ByteArrayHttpEntity(muleEvent.getMessage().getPayloadAsBytes());
        }
        catch (Exception e) {
            throw new MessagingException(muleEvent, (Throwable)e);
        }
    }

    protected MultipartHttpEntity createMultiPart(MuleMessage msg) throws IOException {
        HashMap attachments = Maps.newHashMap();
        for (String outboundAttachmentName : msg.getOutboundAttachmentNames()) {
            attachments.put(outboundAttachmentName, msg.getOutboundAttachment(outboundAttachmentName));
        }
        return new MultipartHttpEntity(HttpPartDataSource.createFrom(attachments));
    }

    private boolean doStreaming(HttpRequestBuilder requestBuilder, MuleEvent event) throws MessagingException {
        String transferEncodingHeader = requestBuilder.getHeaders().get("Transfer-Encoding");
        String contentLengthHeader = requestBuilder.getHeaders().get("Content-Length");
        HttpStreamingType requestStreamingMode = this.resolveStreamingType(event);
        Object payload = event.getMessage().getPayload();
        if (requestStreamingMode == HttpStreamingType.AUTO) {
            if (contentLengthHeader != null) {
                if (transferEncodingHeader != null) {
                    requestBuilder.removeHeader("Transfer-Encoding");
                    if (logger.isDebugEnabled()) {
                        logger.debug("Cannot send both Transfer-Encoding and Content-Length headers. Transfer-Encoding will not be sent.");
                    }
                }
                return false;
            }
            if (transferEncodingHeader == null || !transferEncodingHeader.equalsIgnoreCase("chunked")) {
                return payload instanceof InputStream;
            }
            return true;
        }
        if (requestStreamingMode == HttpStreamingType.ALWAYS) {
            if (contentLengthHeader != null) {
                requestBuilder.removeHeader("Content-Length");
                if (logger.isDebugEnabled()) {
                    logger.debug("Content-Length header will not be sent, as the configured requestStreamingMode is ALWAYS");
                }
            }
            if (transferEncodingHeader != null && !transferEncodingHeader.equalsIgnoreCase("chunked")) {
                requestBuilder.removeHeader("Transfer-Encoding");
                if (logger.isDebugEnabled()) {
                    logger.debug("Transfer-Encoding header will be sent with value 'chunked' instead of {}, as the configured requestStreamingMode is NEVER", (Object)transferEncodingHeader);
                }
            }
            return true;
        }
        if (transferEncodingHeader != null) {
            requestBuilder.removeHeader("Transfer-Encoding");
            if (logger.isDebugEnabled()) {
                logger.debug("Transfer-Encoding header will not be sent, as the configured requestStreamingMode is NEVER");
            }
        }
        return false;
    }

    private HttpStreamingType resolveStreamingType(MuleEvent event) {
        return HttpStreamingType.valueOf(this.requestStreamingMode.resolveStringValue(event));
    }

    private HttpSendBodyMode resolveSendBodyMode(MuleEvent event) {
        return HttpSendBodyMode.valueOf(this.sendBody.resolveStringValue(event));
    }
}

