/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import jnr.ffi.CallingConvention;
import jnr.ffi.annotations.IgnoreError;
import jnr.ffi.annotations.SaveError;

public final class NativeFunction {
    private final Method method;
    private final Collection<Annotation> annotations;
    private final boolean saveError;
    private final CallingConvention callingConvention;

    public NativeFunction(Method method2, CallingConvention callingConvention) {
        this.method = method2;
        this.annotations = Collections.unmodifiableCollection(Arrays.asList(method2.getAnnotations()));
        boolean saveError = true;
        for (Annotation a : this.annotations) {
            if (a instanceof IgnoreError) {
                saveError = false;
                continue;
            }
            if (!(a instanceof SaveError)) continue;
            saveError = true;
        }
        this.saveError = saveError;
        this.callingConvention = callingConvention;
    }

    public Collection<Annotation> annotations() {
        return this.annotations;
    }

    public CallingConvention convention() {
        return this.callingConvention;
    }

    public String name() {
        return this.method.getName();
    }

    public boolean isErrnoRequired() {
        return this.saveError;
    }

    public Method getMethod() {
        return this.method;
    }
}

