/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.internal.LocalContext;
import org.jruby.embed.internal.LocalContextProvider;
import org.jruby.util.ClassCache;

public abstract class AbstractLocalContextProvider
implements LocalContextProvider {
    protected final RubyInstanceConfig config;
    protected final LocalVariableBehavior behavior;
    protected boolean lazy = true;

    protected AbstractLocalContextProvider() {
        this(new RubyInstanceConfig());
    }

    protected AbstractLocalContextProvider(RubyInstanceConfig config) {
        this.config = config;
        this.behavior = LocalVariableBehavior.TRANSIENT;
    }

    protected AbstractLocalContextProvider(RubyInstanceConfig config, LocalVariableBehavior behavior) {
        this.config = config;
        this.behavior = behavior;
    }

    protected AbstractLocalContextProvider(LocalVariableBehavior behavior) {
        this.config = new RubyInstanceConfig();
        this.behavior = behavior;
    }

    @Override
    @Deprecated
    public void setLoadPaths(List loadPaths) {
        this.config.setLoadPaths(loadPaths);
    }

    @Override
    @Deprecated
    public void setClassCache(ClassCache classCache) {
        this.config.setClassCache(classCache);
    }

    protected LocalContext getInstance() {
        return new LocalContext(this.config, this.behavior, this.lazy);
    }

    @Override
    public RubyInstanceConfig getRubyInstanceConfig() {
        return this.config;
    }

    @Override
    public LocalVariableBehavior getLocalVariableBehavior() {
        return this.behavior;
    }

    boolean isGlobalRuntimeReady() {
        return Ruby.isGlobalRuntimeReady();
    }

    Ruby getGlobalRuntime(AbstractLocalContextProvider provider) {
        if (this.isGlobalRuntimeReady()) {
            return Ruby.getGlobalRuntime();
        }
        return Ruby.newInstance(provider.config);
    }

    RubyInstanceConfig getGlobalRuntimeConfig(AbstractLocalContextProvider provider) {
        if (this.isGlobalRuntimeReady()) {
            return this.getGlobalRuntime(provider).getInstanceConfig();
        }
        return provider.config;
    }

    static RubyInstanceConfig getGlobalRuntimeConfigOrNew() {
        return Ruby.isGlobalRuntimeReady() ? Ruby.getGlobalRuntime().getInstanceConfig() : new RubyInstanceConfig();
    }
}

