/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalCache;
import org.jruby.util.ByteList;

public class UnmarshalStream
extends InputStream {
    protected final Ruby runtime;
    private final UnmarshalCache cache;
    private final IRubyObject proc;
    private final InputStream inputStream;
    private final boolean taint;
    private final boolean untrust;

    public UnmarshalStream(Ruby runtime, InputStream in, IRubyObject proc2, boolean taint2) throws IOException {
        this(runtime, in, proc2, taint2, false);
    }

    public UnmarshalStream(Ruby runtime, InputStream in, IRubyObject proc2, boolean taint2, boolean untrust2) throws IOException {
        this.runtime = runtime;
        this.cache = new UnmarshalCache(runtime);
        this.proc = proc2;
        this.inputStream = in;
        this.taint = taint2;
        this.untrust = untrust2;
        int major = in.read();
        int minor = in.read();
        if (major == -1 || minor == -1) {
            throw new EOFException("Unexpected end of stream");
        }
        if (major != 4 || minor > 8) {
            throw runtime.newTypeError(String.format("incompatible marshal file format (can't be read)\n\tformat version %d.%d required; %d.%d given", 4, 8, major, minor));
        }
    }

    public IRubyObject unmarshalObject() throws IOException {
        return this.unmarshalObject(new MarshalState(false));
    }

    public IRubyObject unmarshalObject(boolean callProc) throws IOException {
        return this.unmarshalObject(new MarshalState(false), callProc);
    }

    private IRubyObject unmarshalObject(MarshalState state2) throws IOException {
        return this.unmarshalObject(state2, true);
    }

    private IRubyObject unmarshalObject(MarshalState state2, boolean callProc) throws IOException {
        IRubyObject result2;
        int type2 = this.readUnsignedByte();
        if (this.cache.isLinkType(type2)) {
            result2 = this.cache.readLink(this, type2);
            if (callProc && this.runtime.is1_9()) {
                return this.doCallProcForLink(result2, type2);
            }
        } else {
            result2 = this.unmarshalObjectDirectly(type2, state2, callProc);
        }
        result2.setTaint(this.taint);
        result2.setUntrusted(this.untrust);
        return result2;
    }

    public void registerLinkTarget(IRubyObject newObject2) {
        if (MarshalStream.shouldBeRegistered(newObject2)) {
            this.cache.register(newObject2);
        }
    }

    public static RubyModule getModuleFromPath(Ruby runtime, String path2) {
        RubyModule value2 = UnmarshalStream.getConstantFromPath(runtime, path2);
        if (!value2.isModule()) {
            throw runtime.newArgumentError(path2 + " does not refer module");
        }
        return value2;
    }

    public static RubyClass getClassFromPath(Ruby runtime, String path2) {
        RubyModule value2 = UnmarshalStream.getConstantFromPath(runtime, path2);
        if (!value2.isClass()) {
            throw runtime.newArgumentError(path2 + " does not refer class");
        }
        return (RubyClass)value2;
    }

    private static RubyModule getConstantFromPath(Ruby runtime, String path2) {
        RubyModule value2;
        try {
            value2 = runtime.getClassFromPath(path2);
        }
        catch (RaiseException e) {
            if (runtime.getModule("NameError").isInstance(e.getException())) {
                throw runtime.newArgumentError("undefined class/module " + path2);
            }
            throw e;
        }
        return value2;
    }

    private IRubyObject doCallProcForLink(IRubyObject result2, int type2) {
        if (this.proc != null && type2 != 59) {
            return Helpers.invoke(this.getRuntime().getCurrentContext(), this.proc, "call", result2);
        }
        return result2;
    }

    private IRubyObject doCallProcForObj(IRubyObject result2) {
        if (this.proc != null) {
            return Helpers.invoke(this.getRuntime().getCurrentContext(), this.proc, "call", result2);
        }
        return result2;
    }

    private IRubyObject unmarshalObjectDirectly(int type2, MarshalState state2, boolean callProc) throws IOException {
        IRubyObject rubyObj = null;
        switch (type2) {
            case 73: {
                MarshalState childState = new MarshalState(true);
                rubyObj = this.unmarshalObject(childState);
                if (childState.isIvarWaiting()) {
                    this.defaultVariablesUnmarshal(rubyObj);
                }
                return rubyObj;
            }
            case 48: {
                rubyObj = this.runtime.getNil();
                break;
            }
            case 84: {
                rubyObj = this.runtime.getTrue();
                break;
            }
            case 70: {
                rubyObj = this.runtime.getFalse();
                break;
            }
            case 34: {
                rubyObj = RubyString.unmarshalFrom(this);
                break;
            }
            case 105: {
                rubyObj = RubyFixnum.unmarshalFrom(this);
                break;
            }
            case 102: {
                rubyObj = RubyFloat.unmarshalFrom(this);
                break;
            }
            case 47: {
                rubyObj = RubyRegexp.unmarshalFrom(this);
                break;
            }
            case 58: {
                rubyObj = RubySymbol.unmarshalFrom(this);
                break;
            }
            case 91: {
                rubyObj = RubyArray.unmarshalFrom(this);
                break;
            }
            case 123: {
                rubyObj = RubyHash.unmarshalFrom(this, false);
                break;
            }
            case 125: {
                rubyObj = RubyHash.unmarshalFrom(this, true);
                break;
            }
            case 99: {
                rubyObj = RubyClass.unmarshalFrom(this);
                break;
            }
            case 109: {
                rubyObj = RubyModule.unmarshalFrom(this);
                break;
            }
            case 101: {
                RubySymbol moduleName = (RubySymbol)this.unmarshalObject();
                RubyModule tp = UnmarshalStream.getModuleFromPath(this.runtime, moduleName.asJavaString());
                rubyObj = this.unmarshalObject();
                tp.extend_object(rubyObj);
                tp.callMethod(this.runtime.getCurrentContext(), "extended", rubyObj);
                break;
            }
            case 108: {
                rubyObj = RubyBignum.unmarshalFrom(this);
                break;
            }
            case 83: {
                rubyObj = RubyStruct.unmarshalFrom(this);
                break;
            }
            case 111: {
                rubyObj = this.defaultObjectUnmarshal();
                break;
            }
            case 117: {
                rubyObj = this.userUnmarshal(state2);
                break;
            }
            case 85: {
                rubyObj = this.userNewUnmarshal();
                break;
            }
            case 67: {
                rubyObj = this.uclassUnmarshall();
                break;
            }
            default: {
                throw this.getRuntime().newArgumentError("dump format error(" + (char)type2 + ")");
            }
        }
        if (this.runtime.is1_9()) {
            if (callProc) {
                return this.doCallProcForObj(rubyObj);
            }
        } else if (type2 != 58) {
            this.doCallProcForObj(rubyObj);
        }
        return rubyObj;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public int readUnsignedByte() throws IOException {
        int result2 = this.read();
        if (result2 == -1) {
            throw new EOFException("Unexpected end of stream");
        }
        return result2;
    }

    public byte readSignedByte() throws IOException {
        int b2 = this.readUnsignedByte();
        if (b2 > 127) {
            return (byte)(b2 - 256);
        }
        return (byte)b2;
    }

    public ByteList unmarshalString() throws IOException {
        int read2;
        int length2 = this.unmarshalInt();
        byte[] buffer = new byte[length2];
        for (int readLength = 0; readLength < length2; readLength += read2) {
            read2 = this.inputStream.read(buffer, readLength, length2 - readLength);
            if (read2 != -1) continue;
            throw this.getRuntime().newArgumentError("marshal data too short");
        }
        return new ByteList(buffer, false);
    }

    public int unmarshalInt() throws IOException {
        long result2;
        int c = this.readSignedByte();
        if (c == 0) {
            return 0;
        }
        if (4 < c && c < 128) {
            return c - 5;
        }
        if (-129 < c && c < -4) {
            return c + 5;
        }
        if (c > 0) {
            result2 = 0L;
            for (int i2 = 0; i2 < c; ++i2) {
                result2 |= (long)this.readUnsignedByte() << 8 * i2;
            }
        } else {
            c = -c;
            result2 = -1L;
            for (int i3 = 0; i3 < c; ++i3) {
                result2 &= 255L << 8 * i3 ^ 0xFFFFFFFFFFFFFFFFL;
                result2 |= (long)this.readUnsignedByte() << 8 * i3;
            }
        }
        return (int)result2;
    }

    private IRubyObject defaultObjectUnmarshal() throws IOException {
        RubySymbol className = (RubySymbol)this.unmarshalObject(false);
        RubyClass type2 = UnmarshalStream.getClassFromPath(this.runtime, className.toString());
        IRubyObject result2 = (IRubyObject)type2.unmarshal(this);
        return result2;
    }

    public void defaultVariablesUnmarshal(IRubyObject object) throws IOException {
        int count2 = this.unmarshalInt();
        RubyClass cls = object.getMetaClass().getRealClass();
        for (int i2 = 0; i2 < count2; ++i2) {
            IRubyObject key2 = this.unmarshalObject(false);
            if (this.runtime.is1_9() && object instanceof EncodingCapable) {
                EncodingCapable strObj = (EncodingCapable)((Object)object);
                if (key2.asJavaString().equals("E")) {
                    if (this.unmarshalObject().isTrue()) {
                        strObj.setEncoding((Encoding)UTF8Encoding.INSTANCE);
                        continue;
                    }
                    strObj.setEncoding((Encoding)USASCIIEncoding.INSTANCE);
                    continue;
                }
                if (key2.asJavaString().equals("encoding")) {
                    IRubyObject encodingNameObj = this.unmarshalObject(false);
                    String encodingNameStr = encodingNameObj.asJavaString();
                    ByteList encodingName = new ByteList(ByteList.plain((CharSequence)encodingNameStr));
                    EncodingDB.Entry entry = this.runtime.getEncodingService().findEncodingOrAliasEntry(encodingName);
                    if (entry == null) {
                        throw this.runtime.newArgumentError("invalid encoding in marshaling stream: " + encodingName);
                    }
                    Encoding encoding2 = entry.getEncoding();
                    strObj.setEncoding(encoding2);
                    continue;
                }
            }
            String name2 = key2.asJavaString();
            IRubyObject value2 = this.unmarshalObject();
            cls.getVariableAccessorForWrite(name2).set(object, value2);
        }
    }

    private IRubyObject uclassUnmarshall() throws IOException {
        RubySymbol className = (RubySymbol)this.unmarshalObject(false);
        RubyClass type2 = UnmarshalStream.getClassFromPath(this.runtime, className.asJavaString());
        if (type2.isSingleton()) {
            throw this.runtime.newTypeError("singleton can't be loaded");
        }
        RubyObject result2 = (RubyObject)this.unmarshalObject();
        if (!(result2.getMetaClass() != this.runtime.getModule() && type2.isKindOfModule(result2.getMetaClass()) || type2.getAllocator() == result2.getMetaClass().getRealClass().getAllocator())) {
            throw this.runtime.newArgumentError("dump format error (user class)");
        }
        result2.setMetaClass(type2);
        return result2;
    }

    private IRubyObject userUnmarshal(MarshalState state2) throws IOException {
        String className = this.unmarshalObject(false).asJavaString();
        ByteList marshaled = this.unmarshalString();
        RubyClass classInstance = this.findClass(className);
        RubyString data2 = RubyString.newString(this.runtime, marshaled);
        if (state2.isIvarWaiting()) {
            this.defaultVariablesUnmarshal(data2);
            state2.setIvarWaiting(false);
        }
        IRubyObject unmarshaled = classInstance.smartLoadOldUser(data2);
        this.registerLinkTarget(unmarshaled);
        return unmarshaled;
    }

    private IRubyObject userNewUnmarshal() throws IOException {
        String className = this.unmarshalObject(false).asJavaString();
        RubyClass classInstance = this.findClass(className);
        IRubyObject result2 = classInstance.allocate();
        this.registerLinkTarget(result2);
        IRubyObject marshaled = this.unmarshalObject();
        return classInstance.smartLoadNewUser(result2, marshaled);
    }

    private RubyClass findClass(String className) {
        return UnmarshalStream.getClassFromPath(this.runtime, className);
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    private static class MarshalState {
        private boolean ivarWaiting;

        MarshalState(boolean ivarWaiting) {
            this.ivarWaiting = ivarWaiting;
        }

        boolean isIvarWaiting() {
            return this.ivarWaiting;
        }

        void setIvarWaiting(boolean ivarWaiting) {
            this.ivarWaiting = ivarWaiting;
        }
    }
}

