/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.mule.api.config.MuleConfiguration;
import org.mule.config.spring.parsers.generic.NamedDefinitionParser;
import org.mule.config.spring.util.ProcessingStrategyUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ConfigurationDefinitionParser
extends NamedDefinitionParser {
    public static final String DEFAULT_EXCEPTION_STRATEGY_ATTRIBUTE = "defaultExceptionStrategy-ref";
    private static final String DEFAULT_OBJECT_SERIALIZER_ATTRIBUTE = "defaultObjectSerializer-ref";

    public ConfigurationDefinitionParser() {
        super("_muleConfiguration");
        this.addIgnored(DEFAULT_EXCEPTION_STRATEGY_ATTRIBUTE);
        this.singleton = true;
    }

    @Override
    protected Class getBeanClass(Element element) {
        return MuleConfiguration.class;
    }

    @Override
    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        this.parseExceptionStrategy(element, builder);
        this.parseObjectSerializer(element, builder);
        ProcessingStrategyUtils.configureProcessingStrategy(element, builder, ProcessingStrategyUtils.DEFAULT_PROCESSING_STRATEGY);
        super.doParse(element, context, builder);
    }

    private void parseExceptionStrategy(Element element, BeanDefinitionBuilder builder) {
        if (element.hasAttribute(DEFAULT_EXCEPTION_STRATEGY_ATTRIBUTE)) {
            builder.addPropertyValue("defaultExceptionStrategyName", (Object)element.getAttribute(DEFAULT_EXCEPTION_STRATEGY_ATTRIBUTE));
        }
    }

    private void parseObjectSerializer(Element element, BeanDefinitionBuilder builder) {
        if (element.hasAttribute(DEFAULT_OBJECT_SERIALIZER_ATTRIBUTE)) {
            builder.addPropertyReference("defaultObjectSerializer", element.getAttribute(DEFAULT_OBJECT_SERIALIZER_ATTRIBUTE));
        }
    }

    @Override
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        return "_muleConfiguration";
    }
}

