/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.parsers.generic.OptionalChildDefinitionParser;
import org.mule.retry.async.AsynchronousRetryTemplate;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class RetryPolicyDefinitionParser
extends OptionalChildDefinitionParser {
    boolean asynchronous = false;

    public RetryPolicyDefinitionParser() {
        super("retryPolicyTemplate");
    }

    public RetryPolicyDefinitionParser(Class clazz) {
        super("retryPolicyTemplate", clazz);
    }

    @Override
    protected boolean isChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (this.isConfigElement(element)) {
            element.setAttribute("id", "_defaultRetryPolicyTemplate");
            return false;
        }
        return true;
    }

    protected boolean isConfigElement(Element element) {
        return this.getParentBeanName(element).equals("_muleConfiguration");
    }

    @Override
    protected void preProcess(Element element) {
        super.preProcess(element);
        this.asynchronous = !Boolean.parseBoolean(element.getAttribute("blocking"));
        element.removeAttribute("blocking");
        if (StringUtils.isNotEmpty((String)element.getAttribute("asynchronous"))) {
            this.asynchronous = Boolean.parseBoolean(element.getAttribute("asynchronous"));
            element.removeAttribute("asynchronous");
            return;
        }
    }

    @Override
    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.parseChild(element, parserContext, builder);
        if (this.asynchronous) {
            BeanDefinitionBuilder bdb = BeanDefinitionBuilder.genericBeanDefinition(AsynchronousRetryTemplate.class);
            if (this.isConfigElement(element)) {
                element.removeAttribute("id");
                element.setAttribute("id", this.getBeanName(element));
                this.wrapDelegateRetryPolicy(element, parserContext, bdb, "_defaultRetryPolicyTemplate");
            } else {
                String asynchWrapperName = parserContext.getReaderContext().generateBeanName((BeanDefinition)bdb.getBeanDefinition());
                this.wrapDelegateRetryPolicy(element, parserContext, bdb, asynchWrapperName);
                BeanDefinition parent = parserContext.getRegistry().getBeanDefinition(this.getParentBeanName(element));
                parent.getPropertyValues().addPropertyValue(this.getPropertyName(element), (Object)new RuntimeBeanReference(asynchWrapperName));
            }
        }
    }

    protected void wrapDelegateRetryPolicy(Element element, ParserContext parserContext, BeanDefinitionBuilder bdb, String asynchWrapperName) {
        bdb.addConstructorArgReference(this.getBeanName(element));
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)bdb.getBeanDefinition(), asynchWrapperName);
        this.registerBeanDefinition(holder, parserContext.getRegistry());
    }
}

