/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.util;

import org.apache.commons.lang.StringUtils;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.construct.flow.DefaultFlowProcessingStrategy;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;
import org.mule.processor.strategy.NonBlockingProcessingStrategy;
import org.mule.processor.strategy.QueuedAsynchronousProcessingStrategy;
import org.mule.processor.strategy.QueuedThreadPerProcessorProcessingStrategy;
import org.mule.processor.strategy.SynchronousProcessingStrategy;
import org.mule.processor.strategy.ThreadPerProcessorProcessingStrategy;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;

public class ProcessingStrategyUtils {
    private static String PROCESSING_STRATEGY_ATTRIBUTE_NAME = "processingStrategy";
    public static String DEFAULT_PROCESSING_STRATEGY = "default";
    public static String SYNC_PROCESSING_STRATEGY = "synchronous";
    public static String NON_BLOCKING_PROCESSING_STRATEGY = "non-blocking";
    public static String ASYNC_PROCESSING_STRATEGY = "asynchronous";
    public static String QUEUED_ASYNC_PROCESSING_STRATEGY = "queued-asynchronous";
    public static String THREAD_PER_PROCESSOR_PROCESSING_STRATEGY = "thread-per-processor";
    public static String QUEUED_THREAD_PER_PROCESSOR_PROCESSING_STRATEGY = "queued-thread-per-processor";

    public static void configureProcessingStrategy(Element element, BeanDefinitionBuilder builder, String defaultStrategy) {
        String processingStrategyName = element.getAttribute(PROCESSING_STRATEGY_ATTRIBUTE_NAME);
        ProcessingStrategy processingStrategy = ProcessingStrategyUtils.parseProcessingStrategy(processingStrategyName);
        if (processingStrategy != null) {
            builder.addPropertyValue(PROCESSING_STRATEGY_ATTRIBUTE_NAME, (Object)processingStrategy);
        } else if (!StringUtils.isBlank((String)processingStrategyName)) {
            builder.addPropertyValue(PROCESSING_STRATEGY_ATTRIBUTE_NAME, (Object)new RuntimeBeanReference(processingStrategyName));
        }
    }

    public static ProcessingStrategy parseProcessingStrategy(String processingStrategy) {
        if (DEFAULT_PROCESSING_STRATEGY.equals(processingStrategy)) {
            return new DefaultFlowProcessingStrategy();
        }
        if (SYNC_PROCESSING_STRATEGY.equals(processingStrategy)) {
            return new SynchronousProcessingStrategy();
        }
        if (NON_BLOCKING_PROCESSING_STRATEGY.equals(processingStrategy)) {
            return new NonBlockingProcessingStrategy();
        }
        if (ASYNC_PROCESSING_STRATEGY.equals(processingStrategy)) {
            return new AsynchronousProcessingStrategy();
        }
        if (QUEUED_ASYNC_PROCESSING_STRATEGY.equals(processingStrategy)) {
            return new QueuedAsynchronousProcessingStrategy();
        }
        if (THREAD_PER_PROCESSOR_PROCESSING_STRATEGY.equals(processingStrategy)) {
            return new ThreadPerProcessorProcessingStrategy();
        }
        if (QUEUED_THREAD_PER_PROCESSOR_PROCESSING_STRATEGY.equals(processingStrategy)) {
            return new QueuedThreadPerProcessorProcessingStrategy();
        }
        return null;
    }
}

