/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import org.neo4j.driver.internal.async.ChannelPipelineBuilder;
import org.neo4j.driver.internal.logging.ChannelActivityLogger;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.PackStreamMessageFormatV1;
import org.neo4j.driver.internal.messaging.PackStreamMessageFormatV2;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPipeline;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.DecoderException;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.ReplayingDecoder;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.neo4j.driver.internal.util.ErrorUtil;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.exceptions.SecurityException;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;

public class HandshakeHandler
extends ReplayingDecoder<Void> {
    private final ChannelPipelineBuilder pipelineBuilder;
    private final ChannelPromise handshakeCompletedPromise;
    private final Logging logging;
    private boolean failed;
    private Logger log;

    public HandshakeHandler(ChannelPipelineBuilder pipelineBuilder, ChannelPromise handshakeCompletedPromise, Logging logging) {
        this.pipelineBuilder = pipelineBuilder;
        this.handshakeCompletedPromise = handshakeCompletedPromise;
        this.logging = logging;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.log = new ChannelActivityLogger(ctx.channel(), this.logging, this.getClass());
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext ctx) {
        this.failed = false;
        this.log = null;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.log.debug("Channel is inactive", new Object[0]);
        if (!this.failed) {
            ServiceUnavailableException error = ErrorUtil.newConnectionTerminatedError();
            this.fail(ctx, error);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable error) {
        if (this.failed) {
            this.log.warn("Another fatal error occurred in the pipeline", error);
        } else {
            this.failed = true;
            Throwable cause = HandshakeHandler.transformError(error);
            this.fail(ctx, cause);
        }
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        int serverSuggestedVersion = in.readInt();
        this.log.debug("S: [Bolt Handshake] %d", serverSuggestedVersion);
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.remove(this);
        switch (serverSuggestedVersion) {
            case 1: {
                this.protocolSelected(new PackStreamMessageFormatV1(), pipeline);
                break;
            }
            case 2: {
                this.protocolSelected(new PackStreamMessageFormatV2(), pipeline);
                break;
            }
            case 0: {
                this.fail(ctx, HandshakeHandler.protocolNoSupportedByServerError());
                break;
            }
            case 1213486160: {
                this.fail(ctx, HandshakeHandler.httpEndpointError());
                break;
            }
            default: {
                this.fail(ctx, HandshakeHandler.protocolNoSupportedByDriverError(serverSuggestedVersion));
            }
        }
    }

    private void protocolSelected(MessageFormat messageFormat, ChannelPipeline pipeline) {
        this.pipelineBuilder.build(messageFormat, pipeline, this.logging);
        this.handshakeCompletedPromise.setSuccess();
    }

    private void fail(ChannelHandlerContext ctx, Throwable error) {
        ctx.close().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.handshakeCompletedPromise.tryFailure(error)));
    }

    private static Throwable protocolNoSupportedByServerError() {
        return new ClientException("The server does not support any of the protocol versions supported by this driver. Ensure that you are using driver and server versions that are compatible with one another.");
    }

    private static Throwable httpEndpointError() {
        return new ClientException("Server responded HTTP. Make sure you are not trying to connect to the http endpoint (HTTP defaults to port 7474 whereas BOLT defaults to port 7687)");
    }

    private static Throwable protocolNoSupportedByDriverError(int suggestedProtocolVersion) {
        return new ClientException("Protocol error, server suggested unexpected protocol version: " + suggestedProtocolVersion);
    }

    private static Throwable transformError(Throwable error) {
        if (error instanceof DecoderException && error.getCause() != null) {
            error = error.getCause();
        }
        if (error instanceof ServiceUnavailableException) {
            return error;
        }
        if (error instanceof SSLHandshakeException) {
            return new SecurityException("Failed to establish secured connection with the server", error);
        }
        return new ServiceUnavailableException("Failed to establish connection with the server", error);
    }
}

